﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <algorithm>
#include <memory>
#include <sstream>
#include <string>
#include <vector>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/util/util_Uuid.h>

#include "ControllerSerialFlashTool_ErrorCode.h"

//!< コマンドを実行します。
#define COMMAND_DO(command)\
    do { if (!(command)) { return false; } } while (NN_STATIC_CONDITION(0))

//!< バッファをアロケートします。
template<typename T>
bool AllocateBuffer(
    ::std::unique_ptr<::std::vector<T>>* pOutValue, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    auto ptr = new ::std::vector<T>(size, T());

    if (ptr == nullptr)
    {
        PrintError("Memory Allocation Failed");

        return false;
    }

    pOutValue->reset(ptr);

    return true;
}

//!< 与えられたバッファの中身を出力します
inline void PrintBuffer(const uint8_t* pBuffer, const int size, const int offsetAddress) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pBuffer);
    NN_SDK_REQUIRES_GREATER(size, 0);
    for (int bufferIndex = 0; bufferIndex < size; ++bufferIndex)
    {
        if (bufferIndex % 16 == 0)
        {
            NN_LOG("\n[Serial Flash Tool] %02xh:   ", offsetAddress + bufferIndex);
        }
        NN_LOG("%02x ", pBuffer[bufferIndex]);
    }
    NN_LOG("\n");
}
