﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_UniquePad.h>

//!< 制御対象の UniquePad を取得します。
bool GetUniquePad(nn::hid::system::UniquePadId* pOutValue) NN_NOEXCEPT;

//!< 対象の UniquePad から出力用のファイル名を、パスに追加します。
bool AppendOutputFileName(std::string* pOutValue, const nn::hid::system::UniquePadId& id) NN_NOEXCEPT;
