﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn.h>

const float LedOriginLeft = 178.0f;
const float TimeSlotOriginLeft = 272.0f;
const float WlanCoexOriginLeft = 500.0f;
const float PlrOriginLeft = 630.0f;

// パケロス算出インターバル (ミリ秒)
const int UpdateIntervals = 1500;

// ローカル通信識別子、アプリケーション ID を使用
const nn::Bit64 LocalCommunicationId = UINT64_C(0x01000000000020D3);

// ネットワークの目的を表す識別子です。
const nn::ldn::IntentId BasicSampleIntentId =
    nn::ldn::MakeIntentId(LocalCommunicationId, UINT16_C(0x0001));
