﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <iomanip>
#include <vector>
#include <list>
#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include "BluetoothSettingTool_Display.h"
#include "BluetoothSettingTool_Pad.h"

namespace BluetoothSettingTool {

/*!--------------------------------------------------------------------------*
  @brief        コンテンツ配置方法

 *---------------------------------------------------------------------------*/
enum ContentAlignment
{
    TopLeft,
    TopCenter,
    TopRight,
    MiddleLeft,
    MiddleCenter,
    MiddleRight,
    BottomLeft,
    BottomCenter,
    BottomRight
};

class UIControl
{
public:
    float X;
    float Y;
    float Width;
    float Height;
    UIControl* Parent;

    UIControl();
    virtual ~UIControl();

    virtual void Show(Display& display);
    virtual void ShowImpl(Display&) = 0;
    virtual void InputPad(Pad&);

    virtual int GetX()
    {
        if(Parent == NULL){ return X; }
        return (Parent->GetX() + X);
    }
    virtual int GetY()
    {
        if(Parent == NULL){ return Y; }
        return (Parent->GetY() + Y);
    }
};

/*!--------------------------------------------------------------------------*
  @brief        ページ

 *---------------------------------------------------------------------------*/
class Page : public UIControl
{
public:
    Page(){}
    virtual ~Page(){}

    virtual void ShowImpl(Display& display);
    virtual void Add(UIControl& ui);
    virtual void Remove(UIControl& ui);
    virtual void Clear();
    virtual void UpdateElements();

private:
    list<UIControl*> controls;
};

/*!--------------------------------------------------------------------------*
  @brief        ラベル

 *---------------------------------------------------------------------------*/
class Label : public UIControl
{
public:
    string Text;
    float FontWidth;
    float FontHeight;
    float FixedWidth;
    Color BackgroundColor;
    Color TextColor;
    ContentAlignment Alignment;

    virtual void ShowImpl(Display& display);
    virtual void FitSize();
    Label();

public:
    ContentAlignment GetAlignment() { return Alignment; }
    void SetAlignment(ContentAlignment a) { Alignment = a; }

    void SetFgColor(Color c){ TextColor = c; }
    void SetBgColor(Color c){ BackgroundColor = c; }

    Color GetFgColor(){ return TextColor; }
    Color GetBgColor(){ return BackgroundColor; }
};

}    // namespace BluetoothSettingTool
