﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Base/BcatTestApp_Sequence.h"

namespace app
{
    extern ExecCallbackGroup ExecInputStringGroup;

    const RectanglePosition Position_InputString = { 310, 160, 970, 530 };

    const int DrawPriority_InputString = 7000;

    // 文字入力のカーソル
    const int DrawColorSet_InputStrCursorBack    = 0x488080ff;

    // 文字入力のフレームと背景色
    const int DrawColorSet_InputStringFrame = 0x8a8a90ff;
    const int DrawColorSet_InputStringBack  = 0x1a1a90ff;

    static const int InputStringLenMax = 32;

    //----------------------------------------------------------------
    // 入力パラメータ
    //
    struct InputStringParam
    {
        static const int consoleSizeX = 100;
        static const int consoleSizeY = 30;

        // 初期文字列
        char initialInputStr[ InputStringLenMax + 1 ];
        int inputStrLen;

        // コンソール
        app::FixedProportionalConsole<char16_t>* pConsole16;
        char* pConsoleBuffer;
        app::FixedConsole<char16_t>* pFixedConsole16;
        char* pFixedConsoleBuffer;
        int messageLines;

        // 戻りディレイ
        int delayFrame;

    public:
        InputStringParam()  NN_NOEXCEPT :
            inputStrLen( InputStringLenMax ),
            pConsole16( nullptr ),
            pConsoleBuffer( nullptr ),
            messageLines( 2 ),
            delayFrame( 0 )
        {
            initialInputStr[0] = '\0';
        }

        app::FixedProportionalConsole<char16_t>* GetConsole() NN_NOEXCEPT
        {
            return pConsole16;
        }
        app::FixedConsole<char16_t>* GetFixedConsole() NN_NOEXCEPT
        {
            return pFixedConsole16;
        }

        void SetReturnDelay( int count ) NN_NOEXCEPT
        {
            NN_ASSERT( 0 < count );
            delayFrame = count;
        }

        void SetLength( int len ) NN_NOEXCEPT
        {
            NN_ASSERT( 0 < len && len <= InputStringLenMax );
            inputStrLen = len;
        }

        void SetMessageLines( int lines ) NN_NOEXCEPT
        {
            NN_ASSERT( 0 <= lines && lines < 10 );
            messageLines = lines;
        }

        void SetInitialString( const char* s ) NN_NOEXCEPT
        {
            NN_ASSERT( s && strlen(s) <= InputStringLenMax );
            std::strncpy( initialInputStr, s, sizeof(initialInputStr) - 1 );
            initialInputStr[ InputStringLenMax ] = '\0';
        }
    };

    //----------------------------------------------------------------
    // 出力パラメータ
    //
    struct InputStringReturnParam
    {
        bool isInputStrValid;
        char inputStr[ InputStringLenMax + 1 ];

    public:
        char* GetString() NN_NOEXCEPT
        {
            if ( ! isInputStrValid )
            {
                return nullptr;
            }
            return inputStr;
        }
        bool IsValid() NN_NOEXCEPT
        {
            return isInputStrValid;
        }
    };

    InputStringParam* AllocInputStringParam() NN_NOEXCEPT;
}
