﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Api.h>
#include <nn/account/account_Selector.h>

namespace app
{
    // セーブファイル保存のためのユーザ選択
    nn::Result SelectUser() NN_NOEXCEPT;

    // 選択したユーザの Uid を取得
    nn::account::Uid& GetUser() NN_NOEXCEPT;

    // ユーザを選択しているかどうか
    bool IsUserValid() NN_NOEXCEPT;

    // どのユーザを選択したかの記憶を解放
    void ForgetUser() NN_NOEXCEPT;
}
