﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

namespace app {

typedef void (*ExecCallback)( const glv::HidEvents&, void* );
typedef void (*DrawCallback)( void* );

struct TaskCallbackInfo
{
    ExecCallback callback;
    void* callbackArg;
    int priority;
};

enum
{
    Sequence_Initialize = 0,
};

// 実行コールバックグループ
struct ExecCallbackGroup
{
    app::ExecCallback execInitializeCallback;
    app::ExecCallback execCallback;
    app::ExecCallback execFinalizeCallback;
    void* execCallbackArg;

    app::DrawCallback drawAutoCallback;
    void* drawAutoCallbackArg;
    int drawAutoCallbackPriority;
    int drawAutoCallbackTag;
};

namespace sequence
{
    static const int PriorityMin = 0;
    static const int PriorityMax = 10000;

    // 描画コールバック呼び出し
    void InvokeDrawCallbacks( void* ) NN_NOEXCEPT;

    // 描画コールバック登録
    void EnableDraw() NN_NOEXCEPT;
    void AddDrawCallback( DrawCallback callback, void* arg, int priority, int tag=0 ) NN_NOEXCEPT;
    //void SetDrawCallbackCaller( ExecCallback execCallback, DrawCallback callback, int tag = 0 ) NN_NOEXCEPT; 呼び出しexecCallback の捻じ曲げ
    void RemoveDrawCallback( DrawCallback callback ) NN_NOEXCEPT;
    void RemoveDrawCallbackWithTag( DrawCallback callback, int tag ) NN_NOEXCEPT;
    //void RemoveDrawCallbackByPriority( int priority ) NN_NOEXCEPT;
    bool IsExistDrawCallback( DrawCallback callback ) NN_NOEXCEPT;
    bool IsExistDrawCallback( DrawCallback callback, int tag ) NN_NOEXCEPT;
    uint64_t GetDrawFrameCount() NN_NOEXCEPT;

    void SetDrawFrameSkip( int count ) NN_NOEXCEPT;
    bool IsDrawCallbackActive() NN_NOEXCEPT;

    // タスクコールバック呼び出し
    void AddPreTaskCallback( ExecCallback callback, void* arg, int priority ) NN_NOEXCEPT;
    void RemovePreTaskCallback( ExecCallback callback ) NN_NOEXCEPT;
    bool IsExistPreTaskCallback( ExecCallback callback ) NN_NOEXCEPT;
    void AddPostTaskCallback( ExecCallback callback, void* arg, int priority ) NN_NOEXCEPT;
    void RemovePostTaskCallback( ExecCallback callback ) NN_NOEXCEPT;
    bool IsExistPostTaskCallback( ExecCallback callback ) NN_NOEXCEPT;

    // 実行コールバック呼び出し
    void InvokeExecCallback( const glv::HidEvents& g, void* ) NN_NOEXCEPT;

    static const int SequenceMin = 0;
    void SetEntry( ExecCallback callback, void* arg, int sequence = 0 ) NN_NOEXCEPT;
    void SetEntry( ExecCallbackGroup callbackGroup, int sequence = 0 ) NN_NOEXCEPT;

    void JumpTo( ExecCallbackGroup callbackGroup, int sequence = 0 ) NN_NOEXCEPT;
    void Call( ExecCallbackGroup callbackGroup, int sequence = 0 ) NN_NOEXCEPT;

    void JumpTo( ExecCallbackGroup callbackGroup, void* arg, int sequence = 0 ) NN_NOEXCEPT;
    void Call( ExecCallbackGroup callbackGroup, void* arg, int sequence = 0 ) NN_NOEXCEPT;

    void JumpTo( ExecCallback callback, void* arg=nullptr, int sequence = 0 ) NN_NOEXCEPT;
    void Call( ExecCallback callback, void* arg=nullptr, int sequence = 0 ) NN_NOEXCEPT;
    void SlideTo( ExecCallback callback ) NN_NOEXCEPT;

    void SetFromCall( ExecCallback callback, void* arg ) NN_NOEXCEPT;
    void Return( void* arg=nullptr ) NN_NOEXCEPT;
    void SetSequence( int sequence ) NN_NOEXCEPT;
    int GetSequence() NN_NOEXCEPT;
    void* GetReturnArg() NN_NOEXCEPT;
    uint64_t GetFrameCount() NN_NOEXCEPT;

    void SetFrameContinue( int count ) NN_NOEXCEPT;
}

} //namespace app
