﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <glv.h>

#include "BcatTestApp_Context.h"
#include "BcatTestApp_Sequence.h"

namespace app {

extern ExecCallbackGroup EntryCallbacks;

app::WindowContext* g_MainContext = nullptr;

//----
WindowContext::WindowContext(const unsigned width, const unsigned height) NN_NOEXCEPT
    : glv::Window( width, height ),
      m_ExecCallback( nullptr )
{
    setGLV( m_drawGlv );
}

void WindowContext::OnLoopAttached(glv::ApplicationLoopContext& context) NN_NOEXCEPT
{
    ApplicationLoopCallback::OnLoopAttached(context);
}
void WindowContext::OnLoopDetached(glv::ApplicationLoopContext& context) NN_NOEXCEPT
{
    ApplicationLoopCallback::OnLoopDetached(context);
}
const glv::RequiredRestoration WindowContext::OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT
{
    if ( m_ExecCallback )
    {
        (m_ExecCallback)( events, m_ExecCallbackArg );
    }
    return glv::RequiredRestoration::RequireRestrationNothing;
}
const glv::RequiredRestoration WindowContext::OnLoopAfterSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT
{
    return glv::RequiredRestoration::RequireRestrationNothing;
}

//----------------------------------------------------------------
void Main( glv::Window& window ) NN_NOEXCEPT
{
    // ウィンドウ
    const int width = glv::glutGet(GLUT_SCREEN_WIDTH);
    const int height = glv::glutGet(GLUT_SCREEN_HEIGHT);
    g_MainContext = new app::WindowContext(width, height);

    {
        glv::ApplicationFrameworkRegisterLoopCallback( g_MainContext );

        //glv::Style::standard().color.set( glv::StyleColor::BlackOnWhite );
        //glv::Style::standard().color.set( glv::StyleColor::WhiteOnBlack );
        //glv::Style::standard().color.set( glv::StyleColor::SmokyGray );
        glv::Style::standard().color.set( glv::StyleColor::Gray );

        // 最初のフレームワークコールバックを設定
        g_MainContext->SetExecCallback( app::sequence::InvokeExecCallback, nullptr );
        g_MainContext->SetDrawCallback( app::sequence::InvokeDrawCallbacks, nullptr );

        // ユーザ指定のエントリー位置をシーケンサにセット
        app::sequence::SetEntry( EntryCallbacks );

        glv::Application::run();
    }

    delete g_MainContext;
    g_MainContext = nullptr;

    glv::Application::quit();
}

} //namespace app
