﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "BcatSystemDebugTool_Common.h"

namespace app
{
struct TextResourceData
{
    const int m_Index;
    const bool m_IsDifference;
    const char16_t* m_StringJa;
    const char16_t* m_StringEn;
};

const TextResourceData g_Data[] =
{
    //----------------------------------------------------------------
    {
        TextResource_TopMenuTitle,
        true,
        u"<< トップメニュー >>",
        u"<< Top Menu >>",
    },
    {
        TextResource_ListApplications,
        true,
        u"アプリケーション一覧 ...",
        u"Application list ..."
    },
    {
        TextResource_UnmountStorage,
        true,
        u"データ配信キャッシュストレージのアンマウント",
        u"Unmount storage",
    },
    {
        TextResource_DisconnectNetwork,
        true,
        u"ネットワークを切断",
        u"Disconnect from the network",
    },
    {
        TextResource_ConnectNetwork,
        true,
        u"ネットワークに接続",
        u"Connect to the network",
    },
    {
        TextResource_ViewPushNotificationLog,
        true,
        u"プッシュ通知ログをみる",
        u"View push notifications log",
    },
    {
        TextResource_StartSubscribing,
        true,
        u"購読の開始 (未実装)",
        u"Start subscribing (not implemented)",
    },
    {
        TextResource_OtherMenu,
        true,
        u"その他 ...",
        u"Other ...",
    },
    //----------------------------------------------------------------
    {
        TextResource_OtherMenuTitle,
        true,
        u"-- その他 --",
        u"-- Other --",
    },
    {
        TextResource_CancelUserSelect,
        true,
        u"ユーザの選択を解除する",
        u"Clear user selections",
    },
    {
        TextResource_CancelUserSelectDone,
        true,
        u"ユーザ選択を解除しました。",
        u"User selections were cleared.",
    },
    {
        TextResource_SwitchLanguage,
        true,
        u"言語を英語に切り替える ( Change the language to English )",
        u"Change the Language to Japanese ( 言語を日本語に切り替える )",
    },
    {
        TextResource_BackFromOtherMenu,
        true,
        u"戻る",
        u"Back",
    },
    {
        TextResource_ConnectingNetwork,
        true,
        u"ネットワークに接続しています",
        u"Connecting to the network ...",
    },
    {
        TextResource_PushButtonBToAbort,
        true,
        u"B ボタンで中断できます",
        u"Press the B Button to cancel",
    },
    {
        TextResource_Connected,
        true,
        u"接続しました",
        u"Connected.",
    },
    {
        TextResource_PushButtonA,
        true,
        u"A ボタンを押してください",
        u"Press the A Button",
    },
    {
        TextResource_Disconnecting,
        true,
        u"切断しています",
        u"Disconnecting ...",
    },
    {
        TextResource_Disconnected,
        true,
        u"切断しました",
        u"Disconnected.",
    },
    {
        TextResource_FailedConnectNetwork,
        true,
        u"ネットワークへの接続に失敗しました",
        u"Could not connect to the network.",
    },
    {
        TextResource_SortLogTitle,
        true,
        u"-- ログのソート --",
        u"-- Sorting Logs --",
    },
    {
        TextResource_SortByApp,
        true,
        u"Application ID でソート",
        u"Sort by application ID",
    },
    {
        TextResource_SortByAppCurrent,
        true,
        u"Application ID でソート (選択中)",
        u"Sort by application ID (selected)",
    },
    {
        TextResource_SortByNo,
        true,
        u"番号順にソート",
        u"Sort by number.",
    },
    {
        TextResource_SortByNoCurrent,
        true,
        u"番号順にソート (選択中)",
        u"Sort by number (selected)",
    },
    {
        TextResource_AppListInvalidDirName,
        true,
        u"ディレクトリ名が不正です",
        u"The directory name is invalid",
    },
    {
        TextResource_AppListFailedMount,
        true,
        u"マウントに失敗しました",
        u"Mounting failed",
    },
    {
        TextResource_SortAppListTitle,
        true,
        u"-- アプリリストのソート --",
        u"-- Sorting Application List --",
    },
    {
        TextResource_SortAppListByApp,
        true,
        u"Application ID でソート",
        u"Sort by application ID",
    },
    {
        TextResource_SortAppListByAppCurrent,
        true,
        u"Application ID でソート (選択中)",
        u"Sort by application ID (selected)",
    },
    {
        TextResource_SortAppListByBgTask,
        true,
        u"バックグラウンドタスクでソート",
        u"Sort by background task",
    },
    {
        TextResource_SortAppListByBgTaskCurrent,
        true,
        u"バックグラウンドタスクでソート (選択中)",
        u"Sort by background task (selected)",
    },
    {
        TextResource_AppMenuTitle,
        true,
        u"<< アプリケーションメニュー >>",
        u"<< Application Menu >>",
    },
    {
        TextResource_ListDirectories,
        true,
        u"ディレクトリ一覧 ...",
        u"Directory list ...",
    },
    {
        TextResource_RequestToSync,
        true,
        u"データ配信キャッシュの同期要求 ...",
        u"Synchronization request for delivery cache ...",
    },
    {
        TextResource_CancelSyncRequest,
        true,
        u"データ配信キャッシュの同期要求のキャンセル ...",
        u"Cancel synchronization request for delivery cache ...",
    },
    {
        TextResource_UnregisterBgTask,
        true,
        u"バックグラウンドタスクの解除 ...",
        u"Unregister background tasks ...",
    },
    {
        TextResource_DumpToSdCard,
        true,
        u"SD カードへ書き出す ...",
        u"Write to SD card ...",
    },
    {
        TextResource_ClearStorage,
        true,
        u"データ配信キャッシュストレージのクリア ...",
        u"Clear delivery cache storage ...",
    },
    {
        TextResource_ConfirmRequestToSync,
        true,
        u"データ配信キャッシュの同期要求を行いますか?",
        u"Send synchronization request\nfor the delivery cache?",
    },
    {
        TextResource_ConfirmCancelSyncRequest,
        true,
        u"提出中の同期要求をすべてキャンセルします。\nよろしいですか?",
        u"Cancel all submitted synchronization requests.\nAre you ready?",
    },
    {
        TextResource_ConfirmUnregisterBgTask,
        true,
        u"バックグラウンドタスクを解除しますか?",
        u"Unregister background tasks?",
    },
    {
        TextResource_ConfirmDumpToSdCard,
        true,
        u"SDカードへ書き出しますか?",
        u"Write to SD card?",
    },
    {
        TextResource_ConfirmClearStorage,
        true,
        u"データ配信キャッシュストレージをクリアしますか?",
        u"Clear delivery cache storage?",
    },
    {
        TextResource_SdCardDir1,
        true,
        u"保存するSDカード上のディレクトリ名を入力してください",
        u"Enter the directory name on the SD card to save to",
    },
    {
        TextResource_SdCardDir2,
        true,
        u"　以下の部分です。)",
        u" the following part. )",
    },
    {
        TextResource_FailedToEnumerateFiles,
        true,
        u"ファイル一覧の取得に失敗しました\n",
        u"Failed to get file list\n",
    },
    {
        TextResource_SdDirectoryNameGuide,
        true,
        u"保存先 : ",
        u"Save to : ",
    },
    {
        TextResource_FileNameGuide,
        true,
        u"ファイル : ",
        u"File : ",
    },
    {
        TextResource_SavingToSdCard,
        true,
        u"SD カードに保存します\n",
        u"Save to SD card.\n",
    },
    {
        TextResource_SavingToSaveData,
        true,
        u"セーブデータに保存します\n",
        u"Save to save data.\n",
    },
    {
        TextResource_DirectoryNameGuide,
        true,
        u"ディレクトリ : ",
        u"Directory : ",
    },
    {
        TextResource_AllDataSavingDone,
        true,
        u"すべてのデータの処理が終わりました。\n",
        u"Finished processing all data.\n",
    },
    {
        TextResource_FilesSaved,
        true,
        u"保存したファイル : ",
        u"Saved files : ",
    },
    {
        TextResource_FilesSkippedBig,
        true,
        u"サイズが大きくスキップしたファイル : ",
        u"Files skipped because the file size was too large : ",
    },
    {
        TextResource_FilesSkippedNotModiry,
        true,
        u"変更がなくてスキップしたファイル : ",
        u"Files skipped because there were no changes : ",
    },
    {
        TextResource_FilesSaveError,
        true,
        u"保存エラーファイル : ",
        u"Save error file : ",
    },
    {
        TextResource_DirsCreated,
        true,
        u"ディレクトリ作成 : ",
        u"Create directory : ",
    },
    {
        TextResource_DirsCreateError,
        true,
        u"ディレクトリ作成エラー : ",
        u"Create directory error : ",
    },
    {
        TextResource_SaveAllAndButtonA,
        true,
        u"A ボタンを押してください\n",
        u"Press the A Button\n",
    },

    {
        TextResource_LowSaveDataSpace,
        true,
        u"セーブデータの容量が足りませんでした。\n",
        u"Insufficient save data capacity.\n",
    },
    {
        TextResource_FailedCreateSaveData,
        true,
        u"セーブデータの作成に失敗しました。\n",
        u"Failed to create save data.\n",
    },
    {
        TextResource_FailedMountSaveData,
        true,
        u"セーブデータのマウントに失敗しました。\n",
        u"Failed to mount save data.\n",
    },
    {
        TextResource_FailedCreateDirectory,
        true,
        u"ディレクトリの作成に失敗しました\n",
        u"Failed to create directory.\n",
    },
    {
        TextResource_CreatedDirectory,
        true,
        u"ディレクトリを作成しました\n",
        u"Created directory.\n",
    },
    {
        TextResource_FailedCreateFile,
        true,
        u"ファイルの作成に失敗しました\n",
        u"Failed to create file.\n",
    },
    {
        TextResource_FailedOpenFile,
        true,
        u"ファイルオープンに失敗しました\n",
        u"Failed to open file.\n",
    },
    {
        TextResource_FailedCalculateFileHash,
        true,
        u"ファイルのハッシュ計算に失敗しました\n",
        u"Failed to calculate file hash.\n",
    },
    {
        TextResource_SkipBecauseNotModified,
        true,
        u"更新がないのでスキップします.\n",
        u"Skipping the file because there are no updates\n",
    },
    {
        TextResource_ErrorOccurredInReadDeliveryCache,
        true,
        u"データをデータ配信キャッシュから読む途中でエラーが発生しました\n",
        u"An error occurred when loading the data from the delivery cache.\n",
    },
    {
        TextResource_ErrorOccurredInWritingSaveData,
        true,
        u"セーブデータ書き込み中にエラーが発生しました\n",
        u"An error occurred when writing save data.\n",
    },
    {
        TextResource_CopyDone,
        true,
        u"コピーしました\n",
        u"Copied.\n",
    },
    {
        TextResource_SkipBecauseTooBig,
        true,
        u"ファイルが大きすぎるのでスキップします  ",
        u"Skipping the file because the file size is too large. ",
    },
    {
        TextResource_ErrorOccurred,
        true,
        u"エラーが発生しました\n",
        u"An error occurred\n",
    },
    {
        TextResource_FailedReadDeliveryCache,
        true,
        u"データをデータ配信キャッシュから読み込めませんでした\n",
        u"The data could not be loaded from delivery cache.\n",
    },
    {
        TextResource_LowSdCardSpace,
        true,
        u"SD カードの空き容量が不足しています\n",
        u"Insufficient space on the SD card.\n",
    },
    {
        TextResource_ConfirmSdCard,
        true,
        u"SD カードがささっているか確認してください\n",
        u"Check that an SD card is inserted.\n",
    },

    {
        TextResource_HelpTopMenu,
        true,
        u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...決定",
        u"@1Description of operations:@7 @6[Up][Down]@7...Cursor  @4[A]@7...Confirm",
    },
    {
        TextResource_HelpAppList,
        true,
        u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...アプリケーションメニュー  @5[X]@7...サブメニュー  @3[Y]@7...進捗 @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Cursor  @4[A]@7...Application Menu  @5[X]@7...Sub Menu  @3[Y]@7...Forward @2[B]@7...Back",
    },
    {
        TextResource_HelpAppListInputStr,
        true,
        u"@1操作説明:@7 @6[上][下][左][右]@7...カーソル  @4[A]@7...入力  @3[Y]@7...削除  @5[X]@7...決定  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down][Left][Right]@7...Cursor  @4[A]@7...Enter  @3[Y]@7...Delete  @5[X]@7...Confirm  @2[B]@7...Back",
    },
    {
        TextResource_HelpAppListSubMenu,
        true,
        u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...決定  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Cursor  @4[A]@7...Confirm  @2[B]@7...Back",
    },
    {
        TextResource_HelpSaveApplicationMenu,
        true,
        u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...決定  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Cursor  @4[A]@7...Confirm  @2[B]@7...Back",
    },
    {
        TextResource_HelpBinaryDump,
        true,
        u"@1操作説明:@7 @6[上][下]@7...スクロール  @6[左][右]@7...大きくスクロール  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Scroll  @6[Left][Right]@7...Long scroll  @2[B]@7...Back",
    },
    {
        TextResource_HelpBinaryDumpDetailMenu,
        true,
        u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...決定  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Cursor  @4[A]@7...Confirm  @2[B]@7...Back",
    },
    {
        TextResource_HelpFileMenu,
        true,
        u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...ファイルメニュー  @5[X]@7...ダンプ  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Cursor  @4[A]@7...File Menu  @5[X]@7...Dump  @2[B]@7...Back",
    },
    {
        TextResource_HelpFileMenuDir,
        true,
        u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...ディレクトリオープン  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Cursor  @4[A]@7...Open directory  @2[B]@7...Back",
    },
    {
        TextResource_HelpNetworkConnection,
        true,
        u"@1操作説明:@7 @4[B]@7...戻る",
        u"@1Description of operations:@7 @4[B]@7...Back",
    },
    {
        TextResource_HelpOtherMenu,
        true,
        u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...決定  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Cursor  @4[A]@7...Confirm  @2[B]@7...Back",
    },
    {
        TextResource_HelpPushNotificationLogMenu,
        true,
        u"@1操作説明:@7 @6[上][下]@7...スクロール  @5[X]@7...サブメニュー @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Scroll  @5[X]@7...Sub Menu @2[B]@7...Back",
    },
    {
        TextResource_HelpPushNotificationLogMenuSubMenu,
        true,
        u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...決定  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Cursor  @4[A]@7...Confirm  @2[B]@7...Back",
    },
    {
        TextResource_HelpSaveAllFile,
        true,
        u"@1操作説明:@7 @6[上][下]@7...ログのスクロール  @2[B]@7...中断",
        u"@1Description of operations:@7 @6[Up][Down]@7...Scroll log  @2[B]@7...Cancel",
    },
    {
        TextResource_HelpSaveAllFileFinished,
        true,
        u"@1操作説明:@7 @6[上][下]@7...ログのスクロール  @4[A]@7...終了  @2[B]@7...戻る",
        u"@1Description of operations:@7 @6[Up][Down]@7...Scroll log  @4[A]@7...End  @2[B]@7...Back",
    },

};

//----------------------------------------------------------------
// 表示用テキスト
//
const char16_t* GetText( int index ) NN_NOEXCEPT
{
    if ( index < 0 || index >= TextResource_ArrayMax )
    {
        return nullptr;
    }

    const TextResourceData* p = &g_Data[index];

    NN_ASSERT( p->m_Index == index );

    return ( ! p->m_IsDifference )? p->m_StringJa :
           ( IsEnglish() )?         p->m_StringEn :
                                    p->m_StringJa;
}

} // namespace app

