﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

uvec4 CompressRgb(vec4 texels[16])
{
    uvec4 outColor;

    // 各ピクセルの アルファ値を 4bit に量子化する
    uint alphaBits0 = 0;
    for(int i = 0; i < 8; i++)
    {
        float alpha = texels[i].a;
        uint a = uint(round(alpha * 15));
        alphaBits0 |= (a << (i * 4));
    }

    uint alphaBits1 = 0;
    for(int i = 8; i < 16; i++)
    {
        float alpha = texels[i].a;
        uint a = uint(round(alpha * 15));
        alphaBits1 |= (a << ((i - 8) * 4));
    }

    outColor.r = alphaBits0;
    outColor.g = alphaBits1;

    uvec4 compressedRGB = CompressionTextureRGBChannel(texels);
    outColor.b = compressedRGB.r;
    outColor.b |= (compressedRGB.g << 16);
    outColor.a = compressedRGB.b;
    outColor.a |= (compressedRGB.a << 16);
    return outColor;
}

void main()
{
    vec4 sourceTexels[16];

    ivec2 destTextureSize = ivec2(textureSize(sTexture,mipLevel));
    ivec2 roundUpTextureSize = ((destTextureSize + 3) / 4) * 4;

    vec2 sizeRatio = vec2(roundUpTextureSize) / vec2(destTextureSize);
    vec2 fetchOffset = .5 / vec2(destTextureSize);

#if TEXTURE_DIMENSION_IS_2D_ARRAY
    vec3 fetchPosition = vec3((vTexCoord + fetchOffset) * sizeRatio, layer);
#else
    vec2 fetchPosition = vec2((vTexCoord + fetchOffset) * sizeRatio);
#endif

    sourceTexels[ 0] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(-2, -2) );
    sourceTexels[ 1] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(-1, -2) );
    sourceTexels[ 2] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2( 0, -2) );
    sourceTexels[ 3] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(+1, -2) );
    sourceTexels[ 4] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(-2, -1) );
    sourceTexels[ 5] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(-1, -1) );
    sourceTexels[ 6] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2( 0, -1) );
    sourceTexels[ 7] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(+1, -1) );
    sourceTexels[ 8] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(-2,  0) );
    sourceTexels[ 9] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(-1,  0) );
    sourceTexels[10] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2( 0,  0) );
    sourceTexels[11] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(+1,  0) );
    sourceTexels[12] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(-2, +1) );
    sourceTexels[13] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(-1, +1) );
    sourceTexels[14] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2( 0, +1) );
    sourceTexels[15] = textureLodOffset( sTexture, fetchPosition, mipLevel, ivec2(+1, +1) );

    // Srgb フォーマットの場合は、デガンマする。
#if TEXTURE_FORMAT_IS_SRGB
    for (int i = 0; i < 16; i++)
    {
        sourceTexels[i].rgb = RGBToSRGB(sourceTexels[i].rgb);
    }
#endif

    oColor = CompressRgb(sourceTexels);
}

