﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_ShowArgSetEcClientCertEnabled.h>

#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>

//------------------------------------------------------------------------
#include <nn/nn_Middleware.h>
#include <nn/nn_Version.h>
// libnn_web_news のミドルウェア情報です。
#define NN_WEB_MIDDLEWARE_SYMBOL(buildOption) "NintendoSDK_Web_EcClientCert-" NN_MACRO_STRINGIZE(NN_NX_ADDON_VERSION_MAJOR) "_" NN_MACRO_STRINGIZE(NN_NX_ADDON_VERSION_MINOR) "_" NN_MACRO_STRINGIZE(NN_NX_ADDON_VERSION_MICRO) "-" #buildOption

#if defined(NN_SDK_BUILD_DEBUG)
NN_DEFINE_MIDDLEWARE(g_MiddlewareInfo, "Nintendo", NN_WEB_MIDDLEWARE_SYMBOL(Debug));
#elif defined(NN_SDK_BUILD_DEVELOP)
NN_DEFINE_MIDDLEWARE(g_MiddlewareInfo, "Nintendo", NN_WEB_MIDDLEWARE_SYMBOL(Develop));
#elif defined(NN_SDK_BUILD_RELEASE)
NN_DEFINE_MIDDLEWARE(g_MiddlewareInfo, "Nintendo", NN_WEB_MIDDLEWARE_SYMBOL(Release));
#endif
//------------------------------------------------------------------------

namespace nn { namespace web {

//------------------------------------------------------------------------
void SetEcClientCertEnabled(nn::web::ShowWebPageArg* arg) NN_NOEXCEPT
{
    NN_USING_MIDDLEWARE(g_MiddlewareInfo);

    bool isEcClientCertEnabled = true;
    nn::web::common::CommonArgData::SetData(arg->Data(), nn::web::common::CommonArgData::ArgKind::EcClientCertEnabled, sizeof(isEcClientCertEnabled), &isEcClientCertEnabled);
}

}} // namespace nn::web
