﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_LobbyApiPrivate.h>

#include <nn/la/la_CommonArgumentsWriter.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_LobbyApiDetail.h>
#include <nn/web/detail/web_LobbyTypesDetail.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
nn::Result ShowLobbyPage(LobbyPageReturnValue* pOutputLobbyPageReturnValue,
    const ShowLobbyPageArg& arg) NN_NOEXCEPT
{
    auto handle = nn::web::common::CommonApi::PrepareLibraryApplet(applet::AppletId_LibraryAppletLoginShare);

    // 共通引数をプッシュ
    nn::la::CommonArgumentsWriter writer(nn::web::common::ShimVersion, detail::LobbyShimVersion);
    writer.PushToInChannel(handle);

    // シェアページを開くための起動引数をプッシュ
    {
        auto writer = reinterpret_cast<const detail::ShowLobbyPageArgWriter*>(&arg);
        writer->PushToInChannel(handle);
    }

    // ロビーページを開く
    auto result = nn::web::common::CommonApi::StartLibraryAppletAndWait(pOutputLobbyPageReturnValue, sizeof(*pOutputLobbyPageReturnValue), handle);
    if (result.IsSuccess())
    {
        return nn::ResultSuccess();
    }
    else
    {
        return nn::web::ResultTerminated();
    }
}

}} // namespace nn::web
