﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_ApiYouTubeVideo.h>

#include <nn/la/la_CommonArgumentsWriter.h>
#include <nn/web/web_Result.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_TypesDetail.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
nn::Result ShowYouTubeVideo(WebPageReturnValue* pOutputWebPageReturnValue,
    const ShowYouTubeVideoArg& arg) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutputWebPageReturnValue);

    auto handle = nn::web::common::CommonApi::PrepareLibraryApplet(applet::AppletId_LibraryAppletWeb);

    // 共通引数をプッシュ
    nn::la::CommonArgumentsWriter writer(nn::web::common::ShimVersion, detail::WebShimVersion);
    writer.PushToInChannel(handle);

    // YouTubeVideo を開くための起動引数をプッシュ
    nn::web::common::CommonApi::PushStorageToInChannel(handle, arg.Data(), sizeof(ShowYouTubeVideoArg));

    // YouTubeVideo を開く
    auto result = nn::web::common::CommonApi::StartLibraryAppletAndWait(pOutputWebPageReturnValue, sizeof(*pOutputWebPageReturnValue), handle);
    if (result.IsSuccess())
    {
        return nn::ResultSuccess();
    }
    else
    {
        return nn::web::ResultTerminated();
    }
}

}} // namespace nn::web
