﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/TargetConfigs/build_Compiler.h>

// DDK 上で sdk_Stubs.S をビルドできるようにするため、
// svc_BaseId.autogen.h を使用せずシンボルを直接参照するワークアラウンドを行う
#if defined NN_BUILD_CONFIG_CPU_ARM

#define SVC_BREAK_SYMBOL _ZN2nn3svc7aarch325BreakENS0_11BreakReasonEjj

#elif defined NN_BUILD_CONFIG_CPU_ARM64

#if defined NN_BUILD_CONFIG_ABI_ILP32

#define SVC_BREAK_SYMBOL _ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm

#elif defined NN_BUILD_CONFIG_ABI_LP64

#define SVC_BREAK_SYMBOL _ZN2nn3svc7aarch644lp645BreakENS0_11BreakReasonEmm

#else
#error  not defined NN_BUILD_CONFIG_ABI_
#endif // NN_BUILD_CONFIG_ABI_

#else
#error  not defined NN_BUILD_CONFIG_CPU_
#endif // NN_BUILD_CONFIG_CPU_

#if defined NN_BUILD_CONFIG_CPU_ARM

#define DUMMY_SYM(x)                        \
    .section .text;                         \
    .hidden x;                              \
    .global x;                              \
x:;                                         \
    mov     r0, #0;                         \
    mov     r1, #0;                         \
    mov     r2, #0;                         \
    bl      SVC_BREAK_SYMBOL;               \
0:  b       0b

#elif defined NN_BUILD_CONFIG_CPU_ARM64

#define DUMMY_SYM(x)                        \
    .section .text;                         \
    .hidden x;                              \
    .global x;                              \
x:;                                         \
    mov     x0, #0;                         \
    mov     x1, #0;                         \
    mov     x2, #0;                         \
    bl      SVC_BREAK_SYMBOL;               \
0:  b       0b
#else
#error  not defined NN_BUILD_CONFIG_CPU_
#endif

#if defined NN_BUILD_CONFIG_COMPILER_GCC
    DUMMY_SYM(_fork)
    DUMMY_SYM(sigprocmask)
    DUMMY_SYM(_fcntl)
    DUMMY_SYM(_mkdir)
    DUMMY_SYM(_wait)
    DUMMY_SYM(_execve)
    DUMMY_SYM(MIN)
    DUMMY_SYM(_close)
    DUMMY_SYM(_fstat)
    DUMMY_SYM(_isatty)
    DUMMY_SYM(_lseek)
    DUMMY_SYM(_read)
    DUMMY_SYM(_sbrk)
    DUMMY_SYM(_write)
    DUMMY_SYM(_open)
    DUMMY_SYM(_link)
    DUMMY_SYM(_unlink)
    DUMMY_SYM(_stat)
    DUMMY_SYM(_kill)
    DUMMY_SYM(_gettimeofday)
    DUMMY_SYM(_getpid)
    DUMMY_SYM(_times)
    DUMMY_SYM(_exit)
#endif

    // nnApplication.o から参照するシンボル。
    // nnApplication.o をリンクして nnSdk.nss をリンクしなかった場合に未解決シンボルエラーにするため。
    .section .text;
    .global __nnDetailNintendoSdkNsoFile;
__nnDetailNintendoSdkNsoFile:
0:  b       0b
