﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/fs.h>
#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/repair/repair_FileSystem.h>
#include <nn/migration/user/migration_UserMigrationInternalTypes.h>
#include <string>


namespace nn { namespace repair { namespace detail {

//!< migration state 情報を得る為のクラスです。

class ExtractMigration final
{
private:

    //!< マウント名
    static const std::string MountName;

    //!< スペース ID
    const nn::fs::SaveDataSpaceId m_SpaceId;

    //!< Volume 上のパス
    const std::string m_inRootPath;

    //!< SD 上のパス
    const std::string m_outRootPath;


public:
    explicit ExtractMigration(const nn::fs::SaveDataSpaceId& spaceId, const std::string& devicePath) NN_NOEXCEPT
         : m_SpaceId(spaceId), m_inRootPath(MountName + ":/") , m_outRootPath(devicePath + "/")
    {
    }

    //!< Migration 状態を判定
    bool GetMigrationIsActive() NN_NOEXCEPT;

    //!< Migration 状態をSDに書きだす
    nn::Result Export() NN_NOEXCEPT;

private:

    bool IsResumeableMigrationState(nn::migration::user::MigrationState state) const NN_NOEXCEPT;

    bool ReadMigrationStateFile(void * pData, size_t dataSize, const std::string & filename) NN_NOEXCEPT;

    bool CheckFirmwareVersion(uint32_t ver) const NN_NOEXCEPT;

    bool GetMigrationState() NN_NOEXCEPT;

    nn::Result WriteFileData(const std::string& apath) NN_NOEXCEPT;


};

}}} // namespace nn::repair::detail

