﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <forward_list>
#include <nn/nn_Result.h>
#include <nn/repair.h>

namespace nn { namespace repair { namespace detail {

//!< ブラックリストを扱うクラスです。
class BlackList final
{
private:
    //!< ブラック ID のリスト
    std::forward_list<nn::Bit64> m_Ids;

public:
    explicit BlackList(const BlackListStruct* pList) NN_NOEXCEPT
    {
        m_Ids.clear();

        for (int count = 0; count < pList->count; count++)
        {
            m_Ids.push_front(pList->pIds[count]);
        }
    }

    //!< ブラックリストにヒットするか調べます。
    bool IsHit(nn::Bit64 id) const NN_NOEXCEPT;
};

}}} // namespace nn::repair::detail

