﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <forward_list>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include "repair_BlackList.h"

namespace nn { namespace repair { namespace detail {

bool BlackList::IsHit(nn::Bit64 id) const NN_NOEXCEPT
{
    return std::find(m_Ids.begin(), m_Ids.end(), id) != m_Ids.end();
}

}}} // namespace nn::repair::detail

