﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/g3d/g3d_config.h>

#include <cstdio>
#include <cstdarg>

#if NW_G3D_IS_HOST_WIN
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <windows.h>
#include <malloc.h>
#include <crtdbg.h>
#elif NW_G3D_IS_HOST_CAFE
#include <cafe/os.h>
#endif

namespace nw { namespace g3d {

void DebugPrint(const char* format, ...)
{
    NW_G3D_ASSERT_NOT_NULL(format);
#if NW_G3D_IS_HOST_WIN
    va_list arglist;
    va_start(arglist, format);
    int length = vprintf(format, arglist) + 1; // 標準出力にも出力
    if (length > 0)
    {
        char* str = static_cast<char*>(_malloca(length));
        vsprintf_s(str, length, format, arglist);
        va_end(arglist);
        OutputDebugStringA(str);
        _freea(str);
    }
    else
    {
        OutputDebugStringA(format);
    }
#elif NW_G3D_IS_HOST_CAFE
    va_list arglist;
    va_start(arglist, format);
    OSVReport(format, arglist);
    va_end(arglist);
#elif defined(ANDROID)
    va_list arglist;
    va_start(arglist, format);
    __android_log_vprint(ANDROID_LOG_WARN, "g3d", format, arglist);
    va_end(arglist);
#elif defined(__APPLE__)
    va_list arglist;
    va_start(arglist, format);
    vprintf(format, arglist);
    va_end(arglist);
#endif
}

}} // namespace nw::g3d
