﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/g3d/fnd/g3d_WinUtility.h>
#include <cstdlib>

#if NW_G3D_IS_HOST_WIN

namespace nw { namespace g3d { namespace fnd { namespace detail {

namespace {

LRESULT CALLBACK DefWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch (uMsg)
    {
    case WM_PAINT:
        {
            PAINTSTRUCT ps;
            HDC hDC = BeginPaint(hWnd, &ps);
            FillRect(hDC, &ps.rcPaint, static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH)));
            EndPaint(hWnd, &ps);
            return 0;
        }
    case WM_CLOSE:
        PostQuitMessage(EXIT_SUCCESS);
        return 0;
    case WM_ERASEBKGND:
        return FALSE; // BeginPaint で PAINTSTRUCT の fErase を TRUE にする。
    default:
        return DefWindowProcA(hWnd, uMsg, wParam, lParam);
    }
}

} // anonymous namespace

HWND CreateWnd(const CreateWndArg& arg)
{
    HINSTANCE hInstance = GetModuleHandleA(NULL);
    WNDCLASSEXA wc;
    if (!GetClassInfoExA(hInstance, arg.className, &wc))
    {
        // 既存の同名クラスが存在する場合は再利用。
        WNDCLASSEXA wcNew = {
            sizeof(WNDCLASSEX),
            CS_HREDRAW | CS_VREDRAW | CS_OWNDC,
            arg.wndProc ? arg.wndProc : DefWndProc,
            0,
            0,
            hInstance,
            LoadIcon(NULL, IDI_APPLICATION),
            LoadCursor(NULL, IDC_ARROW),
            NULL,
            NULL,
            arg.className,
            LoadIcon(NULL, IDI_APPLICATION)
        };
        ATOM atom = RegisterClassExA(&wcNew);
        if (atom == 0)
        {
            return NULL;
        }
    }

    RECT rect = {0, 0, arg.width, arg.height};
    DWORD dwStyle = WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
    AdjustWindowRect(&rect, dwStyle, FALSE);

    HWND hWnd = CreateWindowExA(
        WS_EX_APPWINDOW | WS_EX_WINDOWEDGE,
        arg.className,
        arg.wndName,
        dwStyle,
        arg.left,
        arg.top,
        rect.right - rect.left,
        rect.bottom - rect.top,
        NULL,
        NULL,
        hInstance,
        NULL
    );

    HDC hDC = GetDC(hWnd);
    SetPixelFormat(hDC);
    ReleaseDC(hWnd, hDC);

    SetForegroundWindow(hWnd);
    SetFocus(hWnd);
    ShowWindow(hWnd, SW_SHOW);

    return hWnd;
}

bool DestroyWnd(HWND hWnd)
{
    ULONG_PTR atom = GetClassLongPtrA(hWnd, GCW_ATOM);
    if (atom == 0)
    {
        return false;
    }
    if (!DestroyWindow(hWnd))
    {
        return false;
    }
    HINSTANCE hInstance = GetModuleHandleA(NULL);
    return FALSE != UnregisterClassA(reinterpret_cast<LPCSTR>(atom), hInstance);;
}

HWND CreateSystemWnd()
{
    HINSTANCE hInstance = GetModuleHandleA(NULL);
    const char* className = "g3d_systemwindow";
    WNDCLASSEXA wc;
    if (!GetClassInfoExA(hInstance, className, &wc))
    {
        // 既存の同名クラスが存在する場合は再利用。
        WNDCLASSEXA wcNew;
        memset(&wcNew, 0, sizeof(WNDCLASSEX));
        wcNew.cbSize = sizeof(WNDCLASSEX);
        wcNew.lpfnWndProc = DefWindowProcA;
        wcNew.hInstance = hInstance;
        wcNew.lpszClassName = className;
        ATOM atom = RegisterClassExA(&wcNew);
        if (atom == 0)
        {
            return NULL;
        }
    }

    HWND hWnd = CreateWindowExA(
        WS_EX_APPWINDOW | WS_EX_WINDOWEDGE,
        className,
        NULL,
        0,
        CW_USEDEFAULT, CW_USEDEFAULT,
        0,
        0,
        NULL,
        NULL,
        hInstance,
        NULL
    );

    return hWnd;
}

int SetPixelFormat(HDC hDC)
{
    int pixFmt = GetPixelFormat(hDC);
    if (pixFmt == 0)
    {
        PIXELFORMATDESCRIPTOR pfd = {
            sizeof(PIXELFORMATDESCRIPTOR),  //  size of this pfd
            1,                     // version number
            PFD_DRAW_TO_WINDOW |   // support window
            PFD_SUPPORT_OPENGL |   // support OpenGL
            PFD_DOUBLEBUFFER,      // double buffered
            PFD_TYPE_RGBA,         // RGBA type
            24,                    // 24-bit color depth
            0, 0, 0, 0, 0, 0,      // color bits ignored
            0, 0,                  // alpha bits ignored
            0,                     // no accumulation buffer
            0, 0, 0, 0,            // accum bits ignored
            0,                     // no z-buffer
            0,                     // no stencil buffer
            0,                     // no auxiliary buffer
            PFD_MAIN_PLANE,        // main layer
            0,                     // reserved
            0, 0, 0                // layer masks ignored
        };
        pixFmt = ChoosePixelFormat(hDC, &pfd);
        if (pixFmt)
        {
            if (!SetPixelFormat(hDC, pixFmt, &pfd))
            {
                return 0;
            }
            DescribePixelFormat(hDC, pixFmt, sizeof(PIXELFORMATDESCRIPTOR), &pfd);
        }
    }
    return pixFmt;
}

#define WGL_CONTEXT_DEBUG_BIT_ARB      0x00000001
#define WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB 0x00000002
#define WGL_CONTEXT_FLAGS_ARB          0x2094
typedef HGLRC (WINAPI * PFNWGLCREATECONTEXTATTRIBSARBPROC)
    (HDC hDC, HGLRC hShareContext, const int *attribList);

HGLRC CreateGLContext(HDC hDC, HGLRC hSharedRC)
{
    if (!SetPixelFormat(hDC))
    {
        return NULL;
    }
    HGLRC hRC = wglCreateContext(hDC);
#if 0 // パフォーマンスに影響するため一旦無効化
    if (hRC)
    {
        // デバッグビットを有効にしたコンテクストに差し替えます。
        wglMakeCurrent(hDC, hRC);
        int attribs[] = {
            WGL_CONTEXT_FLAGS_ARB,
            WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB | WGL_CONTEXT_DEBUG_BIT_ARB,
            0
        };

        PFNWGLCREATECONTEXTATTRIBSARBPROC wglCreateContextAttribsARB =
            (PFNWGLCREATECONTEXTATTRIBSARBPROC) wglGetProcAddress("wglCreateContextAttribsARB");
        if(wglCreateContextAttribsARB != NULL)
        {
            HGLRC hRCDebug = wglCreateContextAttribsARB(hDC, 0, attribs);
            if (hRCDebug)
            {
                wglDeleteContext(hRC);
                hRC = hRCDebug;
            }
        }

        wglMakeCurrent(NULL, NULL);
    }
#endif
    if (hRC && hSharedRC)
    {
        //wglCopyContext(hSharedRC, hRC, GL_ALL_ATTRIB_BITS);
        wglShareLists(hSharedRC, hRC);
    }
    return hRC;
}

void DeleteGLContext(HGLRC hRC)
{
    if (hRC)
    {
        wglDeleteContext(hRC);
    }
}

}}}} // namespace nw::g3d::fnd::detail

#endif // NW_G3D_IS_HOST_WIN
