﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/g3d_EditDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>
#include <nw/g3d/edit/g3d_IAllocator.h>

namespace nw { namespace g3d { namespace edit { namespace ut {

namespace detail {
    class ScopedAllocator
    {
    public:
        ScopedAllocator(IAllocator& allocator, size_t allocateSize, uintptr_t alignment)
            : m_pAllocator(&allocator)
            , m_AllocatedSize(allocateSize)
        {
            m_pBuffer = m_pAllocator->Alloc(allocateSize, alignment);
            NW_G3D_ASSERTMSG(m_pBuffer != NULL, "insufficient memory");
        }
        ~ScopedAllocator()
        {
            m_pAllocator->Free(m_pBuffer);
            m_pAllocator = NULL;
            m_pBuffer = NULL;
        }

        void* GetAllocatedBuffer()
        {
            return m_pBuffer;
        }

        const void* GetAllocatedBuffer() const
        {
            return m_pBuffer;
        }

        size_t GetAllocatedSize() const
        {
            return m_AllocatedSize;
        }

    private:
        IAllocator* m_pAllocator;
        void* m_pBuffer;
        size_t m_AllocatedSize;
    };
}
}}}}

#endif
