﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/g3d_EditDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>
#include "g3d_EditSocket.h"

namespace nw {
namespace g3d {
namespace edit {
namespace detail {

class PingMonitor
{
    NW_G3D_DISALLOW_COPY_AND_ASSIGN( PingMonitor );

public:
    explicit PingMonitor();
    ~PingMonitor() throw();

    bool Initialize(u32 codePage);

    bool Open();
    void Close();

    bool IsOpened() const
    {
        return m_IsHostIoOpened;
    }

    void Poll();

    void ClearState();

    void BeginFreeze(bool sync)
    {
        NW_G3D_EDIT_PRINT("{\n");
        m_IsBeginFreezeEnabled = true;

        if (sync)
        {
            m_SendPingPacket.block.state = PING_STATE_LOCK;
            m_IsCommSyncEnabled = true;
        }
        else
        {
            m_SendPingPacket.block.state = PING_STATE_NORMAL;
            m_IsCommSyncEnabled = false;
        }
    }

    void EndFreeze()
    {
        NW_G3D_EDIT_PRINT("}\n");
        m_IsBeginFreezeEnabled = false;
        m_SendPingPacket.block.state = PING_STATE_UNLOCK;
    }

    void SetRuntimeStateToNormal()
    {
        m_SendPingPacket.block.state = PING_STATE_NORMAL;
    }

    bool IsFreezing() const
    {
        return m_IsBeginFreezeEnabled;
    }

private:
    void AnalyzePingPacket();

    nw::g3d::edit::detail::EditSocket m_PingSocket;
    nw::g3d::edit::detail::PingPacket m_RecvPingPacket;
    nw::g3d::edit::detail::PingPacket m_SendPingPacket;

    volatile bool m_IsBeginFreezeEnabled;
    volatile bool m_IsCommSyncEnabled; //通信処理同期フラグ

    volatile bool m_IsReadStarted;
    volatile bool m_IsWriteStarted;
    volatile bool m_IsWritePingSucceeded;
    bool m_IsHostIoOpened;
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
