﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "g3d_EditAnimObj.h"

namespace nw { namespace g3d {

class ModelAnimObj;

namespace res {

class ResFile;

} // namespace res

namespace edit {
class IAllocator;

namespace detail {

class EditVisibilityAnimObj : public EditAnimObj
{
public:
    virtual ~EditVisibilityAnimObj()
    {
    }

    virtual bool CreateDataForEditingAnimCurve();
    virtual void DestroyDataForEditingAnimCurve();

    void EditCurve(
        int curveIndex,
        const nw::g3d::res::ResAnimCurve* resAnimCurve,
        u32 resAnimCurveSize);

protected:
    explicit EditVisibilityAnimObj(IAllocator* pAllocator, nw::g3d::res::ResFile* pResFile, EditAnimKind animKind)
        : EditAnimObj(pAllocator, pResFile, animKind)
        , m_pEditAnimCurveArray(NULL)
        , m_EditAnimCurveCount(0)
    {
    }

    virtual bool SetupInternal(ModelObj* pBindTargetModelObj, ModelAnimObj* pBoundAnimObj);
    virtual ModelAnimObj* CreateAnimObj()
    {
        void* buffer = m_pAllocator->Alloc(sizeof(VisibilityAnimObj), DEFAULT_ALIGNMENT);
        VisibilityAnimObj* pAnimObj = new (buffer) VisibilityAnimObj();
        return pAnimObj;
    }

protected:
    EditAnimCurve*              m_pEditAnimCurveArray;
    int m_EditAnimCurveCount;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditVisibilityAnimObj);
};

class EditBoneVisibilityAnimObj : public EditVisibilityAnimObj
{
public:
    explicit EditBoneVisibilityAnimObj(IAllocator* allocator, nw::g3d::res::ResFile* pResFile)
        : EditVisibilityAnimObj(allocator, pResFile, EDIT_BONE_VIS_ANIM)
    {
    }

    virtual ~EditBoneVisibilityAnimObj()
    {
        UnbindAllModelObjs();
        DestroyDataForEditingAnimCurve();
    }

    virtual const char* GetName() const
    {
        NW_G3D_EDIT_ASSERT (m_pResFile->GetBoneVisAnimCount() > 0);
        return m_pResFile->GetBoneVisAnim(0)->GetName();
    }

protected:
    virtual void ResetToOriginalValue(ModelObj* pBoundModelObj);

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditBoneVisibilityAnimObj);
};

class EditMatVisibilityAnimObj : public EditVisibilityAnimObj
{
public:
    explicit EditMatVisibilityAnimObj(IAllocator* allocator, nw::g3d::res::ResFile* pResFile)
        : EditVisibilityAnimObj(allocator, pResFile, EDIT_MAT_VIS_ANIM)
    {
    }

    virtual ~EditMatVisibilityAnimObj()
    {
        UnbindAllModelObjs();
        DestroyDataForEditingAnimCurve();
    }

    virtual const char* GetName() const
    {
        NW_G3D_EDIT_ASSERT (m_pResFile->GetMatVisAnimCount() > 0);
        return m_pResFile->GetMatVisAnim(0)->GetName();
    }

protected:
    virtual void ResetToOriginalValue(ModelObj* pBoundModelObj);

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditMatVisibilityAnimObj);
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
