﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "g3d_EditAnimObj.h"

namespace nw { namespace g3d {

class ModelAnimObj;

namespace res {

class ResFile;

} // namespace res

namespace edit {
class IAllocator;

namespace detail {

class EditTexPatternAnimObj : public EditAnimObj
{
public:
    explicit EditTexPatternAnimObj(IAllocator* pAllocator, nw::g3d::res::ResFile* pResFile)
        : EditAnimObj(pAllocator, pResFile, EDIT_TEX_PATTERN_ANIM)
        , m_pMatAnimArray(NULL)
        , m_MatAnimCount(0)
    {
    }

    virtual ~EditTexPatternAnimObj()
    {
        UnbindAllModelObjs();
        DestroyDataForEditingAnimCurve();
    }

    virtual bool CreateDataForEditingAnimCurve();
    virtual void DestroyDataForEditingAnimCurve();
    void EditCurve(
        int matAnimIndex,
        int curveIndex,
        const nw::g3d::res::ResAnimCurve* resAnimCurve,
        u32 resAnimCurveSize);

protected:
    virtual bool SetupInternal(ModelObj* pBindTargetModelObj, ModelAnimObj* pBoundAnimObj);
    virtual void ResetToOriginalValue(ModelObj* pBoundModelObj);
    virtual ModelAnimObj* CreateAnimObj()
    {
        void* buffer = m_pAllocator->Alloc(sizeof(TexPatternAnimObj), DEFAULT_ALIGNMENT);
        TexPatternAnimObj* pAnimObj = new (buffer) TexPatternAnimObj();
        return pAnimObj;
    }

private:
    class EditTexPatternMatAnim;
    EditTexPatternMatAnim*   m_pMatAnimArray;
    int                         m_MatAnimCount;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditTexPatternAnimObj);
};


}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
