﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditSkeletonObj.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/res/g3d_ResFile.h>
#include <nw/g3d/edit/g3d_IAllocator.h>
#include <nw/g3d/g3d_ModelObj.h>

namespace nw { namespace g3d { namespace edit { namespace detail {

using namespace nw::g3d::edit::ut::detail;

EditSkeletonObj::EditSkeletonObj(IAllocator* allocator)
    : m_pAllocator(allocator)
    , m_pOwnerModel(NULL)
    , m_pSkeleton(NULL)
    , m_WorkBuffer(allocator, SkeletonObj::BUFFER_ALIGNMENT)
    , m_WorkBlockBuffer(allocator, SkeletonObj::BLOCK_BUFFER_ALIGNMENT)
{
    NW_G3D_ASSERT_NOT_NULL(allocator);
}

void
EditSkeletonObj::Setup()
{
}

void
EditSkeletonObj::Cleanup()
{
    nw::g3d::SkeletonObj::InitArg arg(m_pOriginalSkeleton);
    arg.BufferingCount(m_OriginalBufferingCount);

    void* userPtr = m_pSkeleton->GetUserPtr();// UserPtr を保持するために一時退避
    if (m_WorkBlockBuffer.Size() > 0)
    {
        m_pSkeleton->CleanupBlockBuffer();
    }

    m_pSkeleton->Init(arg, m_pOriginalBuffer, m_OriginalBufferSize);
    m_pSkeleton->SetUserPtr(userPtr);

    if (m_OriginalBlockBufferSize > 0)
    {
        m_pSkeleton->SetupBlockBuffer(m_pOriginalBlockBuffer, m_OriginalBlockBufferSize);
    }
}

bool
EditSkeletonObj::Init(nw::g3d::ModelObj* ownerModelObj, nw::g3d::SkeletonObj* skeletonObj)
{
    NW_G3D_ASSERT_NOT_NULL(ownerModelObj);
    NW_G3D_ASSERT_NOT_NULL_DETAIL(skeletonObj, "%s\n", NW_G3D_RES_GET_NAME(ownerModelObj->GetResource(), GetName()));
    nw::g3d::res::ResSkeleton* resSkeleton = skeletonObj->GetResource();
    NW_G3D_ASSERT_NOT_NULL_DETAIL(resSkeleton, "%s\n", NW_G3D_RES_GET_NAME(ownerModelObj->GetResource(), GetName()));

    m_pOwnerModel = ownerModelObj;
    m_pSkeleton = skeletonObj;
    m_pOriginalSkeleton = resSkeleton;
    m_OriginalBufferingCount = skeletonObj->GetBufferingCount();

    m_pOriginalBuffer = m_pSkeleton->GetBufferPtr();
    SkeletonObj::InitArg arg(resSkeleton);
    arg.BufferingCount(m_OriginalBufferingCount);
    m_OriginalBufferSize = SkeletonObj::CalcBufferSize(arg);

    m_OriginalBlockBufferSize = m_pSkeleton->CalcBlockBufferSize();
    m_pOriginalBlockBuffer = m_pSkeleton->GetBlockBufferPtr();

    return true;
}

void
EditSkeletonObj::Destroy()
{
    m_WorkBlockBuffer.Clear();
    m_WorkBuffer.Clear();
}

bool
EditSkeletonObj::ReinitBuffer(nw::g3d::res::ResSkeleton* resSkeleton)
{
    nw::g3d::SkeletonObj::InitArg arg(resSkeleton);
    arg.BufferingCount(m_pSkeleton->GetBufferingCount());
    u32 size = m_pSkeleton->CalcBufferSize(arg);
    return m_WorkBuffer.Resize(size);
}

void
EditSkeletonObj::SetupSkeletonInstance(nw::g3d::res::ResSkeleton* resSkeleton)
{
    nw::g3d::SkeletonObj::InitArg arg(resSkeleton);
    arg.BufferingCount(m_pSkeleton->GetBufferingCount());

    void* userPtr = m_pSkeleton->GetUserPtr();// UserPtr を保持するために一時退避
    if (m_OriginalBlockBufferSize > 0)
    {
        m_pSkeleton->CleanupBlockBuffer();
    }

    m_pSkeleton->Init(arg, m_WorkBuffer.GetWorkBufferPtr(), m_WorkBuffer.Size());
    m_pSkeleton->SetUserPtr(userPtr);

    u32 blockBufferSize = m_pSkeleton->CalcBlockBufferSize();
    bool success = m_WorkBlockBuffer.Resize(blockBufferSize);
    NW_G3D_UNUSED(success);
    NW_G3D_ASSERTMSG(
        success,
        "Memory allocation failed, %s\n",
        NW_G3D_RES_GET_NAME(m_pOwnerModel->GetResource(), GetName()));

    if (m_WorkBlockBuffer.Size() > 0)
    {
        m_pSkeleton->SetupBlockBuffer(m_WorkBlockBuffer.GetWorkBufferPtr(), m_WorkBlockBuffer.Size());
    }
}

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
