﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditSkeletalAnimObj.h"

#if NW_G3D_CONFIG_USE_HOSTIO

namespace nw { namespace g3d { namespace edit { namespace detail {

/*virtual*/void
EditSkeletalAnimObj::ResetToOriginalValue(ModelObj* pBoundModelObj)
{
    if (!IsModelBound(pBoundModelObj))
    {
        return;
    }

    pBoundModelObj->GetSkeleton()->ClearLocalMtx();
}

/*virtual*/bool
EditSkeletalAnimObj::CreateDataForEditingAnimCurve()
{
    return true;
}

/*virtual*/void
EditSkeletalAnimObj::DestroyDataForEditingAnimCurve()
{
}

/*virtual*/bool
EditSkeletalAnimObj::SetupInternal(ModelObj* pBindTargetModelObj, ModelAnimObj* pBoundAnimObj)
{
    BindResult result;
    ResModel* pResModel = pBindTargetModelObj->GetResource();
    SkeletalAnimObj* pAnimObj = static_cast<SkeletalAnimObj*>(pBoundAnimObj);
    ResSkeletalAnim* pResSkeletalAnim = static_cast<ResSkeletalAnim*>(GetResAnim());

    SkeletalAnimObj::InitArg initArg;
    initArg.DisableContext();
    initArg.Reserve(pResModel);
    initArg.Reserve(pResSkeletalAnim);
    initArg.EnableRetargeting();

    size_t bufferSize = SkeletalAnimObj::CalcBufferSize(initArg);
    void* buffer = m_pAllocator->Alloc(bufferSize, SkeletalAnimObj::BUFFER_ALIGNMENT);
    NW_G3D_ASSERT_NOT_NULL_DETAIL(buffer, "%s\n", NW_G3D_RES_GET_NAME(pResModel, GetName()));//今は止める
    pAnimObj->Init(initArg, buffer, bufferSize);
    pAnimObj->SetResource(pResSkeletalAnim);

    if (m_pRetargetingHostModel != NULL)
    {
        result = pAnimObj->Bind(pBindTargetModelObj, m_pRetargetingHostModel);
    }
    else
    {
        result = pAnimObj->Bind(pBindTargetModelObj);
    }

    return !result.IsMissed(); // 一つでもバインドできたら成功にする。
}

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
