﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/res/g3d_ResShader.h>
#include "ut/g3d_FixedSizeArray.h"
#include "ut/g3d_EditWorkBuffer.h"

namespace nw { namespace g3d {

namespace res {

class ResShaderArchive;

} // namespace res

namespace edit {

class EditServer;
class IAllocator;

namespace detail {

class EditSocket;
class EditShadingModel;
class EditManager;

/**
    @briefprivate 編集対象シェーダアーカイブクラスです。
 */
class EditShaderArchive
{
public:
    explicit EditShaderArchive(IAllocator* allocator, ResShaderArchive* resShaderArchive);

    /**
        @briefprivate 指定されたResShaderArchiveに対してアタッチ処理を行います。
     */
    bool Attach();

    /**
        @briefprivate アタッチしたResShaderArchiveを元に戻します。
     */
    void Detach();

    const ResShaderArchive* GetTargetResShaderArchive() const
    {
        return m_pTargetResShaderArchive;
    }

    ResShaderArchive* GetTargetResShaderArchive()
    {
        return m_pTargetResShaderArchive;
    }

    void CallOriginalUpdateCallback(ResShadingModel*pResShadingModel, int programIndex) const
    {
        m_pOriginalUpdateProgramCallback(pResShadingModel, programIndex);
    }

    void UpdateShaderProgram(int shadingModelIndex, int shaderProgramIndex, ResShaderArchive* resShaderArchive);
    void UpdateShadingModels(int shadingModelIndices[], u32 indexSize);
    void SendModifiedShaderPrograms(EditSocket* socket);

private:
    void Cleanup();
    void Destroy();

    void DestroyShadingModels();
    void ClearHandles();

private:
    IAllocator*                                     m_pAllocator;
    ResShaderArchive*                               m_pTargetResShaderArchive;
    ut::detail::FixedSizeArray<EditShadingModel>  m_ShadingModelArray;
    UpdateProgramCallback                           m_pOriginalUpdateProgramCallback;

    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditShaderArchive);
};

}} // nw::g3d::edit::detail
}} // namespace nw::g3d

#endif // NW_G3D_CONFIG_USE_HOSTIO
