﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditBlinkingObj.h"

#if NW_G3D_CONFIG_USE_HOSTIO

namespace {
    const int BlinkCountForSelecting = 4;
    const int FramesPerBlinkingForSelecting = 20;
}

namespace nw { namespace g3d { namespace edit { namespace detail {

void BlinkingObj::StartBlinking()
{
    m_RestFrameCountForBlinking = BlinkCountForSelecting * FramesPerBlinkingForSelecting;
    m_IsVisible = true;
}

bool BlinkingObj::UpdateBlinking()
{
    if (m_RestFrameCountForBlinking == 0)
    {
        return false;
    }

    bool isVisible = (m_RestFrameCountForBlinking / BlinkCountForSelecting / 2) % 2 == 0;
    bool isUpdateShapeRequired = isVisible != m_IsVisible;
    if (isUpdateShapeRequired)
    {
        if (isVisible)
        {
            this->Show();
        }
        else
        {
            this->Hide();
        }

        m_IsVisible = isVisible;
    }

    --m_RestFrameCountForBlinking;
    return isUpdateShapeRequired;
}

void BlinkingObj::BreakBlinking()
{
    m_RestFrameCountForBlinking = 0;
    if (this->IsVisibleByDefault())
    {
        this->Show();
    }
    else
    {
        this->Hide();
    }
}

}}}} // nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
