﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nd/nd_Api.h>
#include <nn/nd/nd_Result.h>
#include <nn/nd/nd_Types.h>
#include <nn/nd/detail/nd_InitializationManager.h>
#include <nn/nd/detail/nd_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include "detail/nd_HipcProxyClientResource.h"

namespace nn { namespace nd {

detail::InitializationManager g_Init = NN_ND_DETAIL_INITIALIZATION_MANAGER_INITIALIZER;
sf::ProxyObjectAllocator<detail::ObjectHolder::ProxyObjectCountMax> g_ProxyObjectAllocator = NN_SF_PROXY_OBJECT_ALLOCATOR_INITIALIZER;
detail::ObjectHolder g_ObjectHolder(g_ProxyObjectAllocator);

void Initialize() NN_NOEXCEPT
{
    g_Init.Initialize([&]()
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ObjectHolder.AcquireForApplicatoion());
    });
}

void SetApplicationData(const account::Uid& uid, const void * data, size_t dataSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(uid);
    NN_SDK_REQUIRES_NOT_NULL(data);
    NN_SDK_REQUIRES_MINMAX(dataSize, 1, ApplicationDataSizeMax);

    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ObjectHolder.GetForApplication().SetApplicationData(uid, sf::InBuffer(reinterpret_cast<const char*>(data), dataSize)));
}

void ClearApplicationData(const account::Uid & uid) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(uid);

    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ObjectHolder.GetForApplication().ClearApplicationData(uid));
}

}} // ~namespace nn::nd
