﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <limits>
#include <nn/nn_Common.h>
#include <nn/migration/idc/migration_UserCommandEncryptor.h>

namespace nn { namespace migration { namespace idc {

size_t GetEncryptedUserCommandBlockSize(size_t blockSize) NN_NOEXCEPT
{
    return blockSize + UserCommandAuthenticationSize;
}

size_t GetEncryptedUserCommandSize(size_t blockSize, size_t plainSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_GREATER(blockSize, 0u);
    return plainSize + ((plainSize + blockSize - 1) / blockSize) * (UserCommandAuthenticationSize);
}

size_t GetDecryptedUserCommandSize(size_t blockSize, size_t encryptedSize) NN_NOEXCEPT
{
    return encryptedSize - ((encryptedSize + GetEncryptedUserCommandBlockSize(blockSize) - 1) / GetEncryptedUserCommandBlockSize(blockSize)) * (UserCommandAuthenticationSize);
}

bool IsAcceptableUserCommandSize(size_t blockSize, size_t commandSize) NN_NOEXCEPT
{
    size_t blockCount = (commandSize / blockSize) + ((commandSize % blockSize) == 0 ? 0 : 1);
    return true &&
        blockSize > 0u &&
        blockSize <= std::numeric_limits<size_t>::max() - UserCommandAuthenticationSize &&
        commandSize > 0u &&
        commandSize <= std::numeric_limits<size_t>::max() - blockCount * UserCommandAuthenticationSize;
}

}}};
