﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "manu_CreateUfioRequest.h"
#include "manu_UfioRequestImpl.h"
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace manu {

namespace
{

// 実装クラス UfioRequestImpl を、IManu サービスオブジェクトとして参照できるようにします。
// nn::sf::UnmanagedServiceObject を使用します。
// テンプレート引数の 1 つ目にインターフェイス名を、 2 つ目にそのインターフェイスに対する内部実装を指定します。
// nn::sf::UnmanagedServiceObject 内で IManu インターフェイスと内部実装 UfioRequestImpl の紐付けが行われ、サービスオブジェクト経由での機能へのアクセスが行えるようになります。
nn::sf::UnmanagedServiceObject<IManu, UfioRequest> g_UfioRequest;

}

// 機能へのアクセスは共有ポインタを利用します。
// 共有ポインタを返却する関数を作成し、サービス利用者はその関数で得られた共有ポインタを利用して、機能にアクセスします。
nn::sf::SharedPointer<IManu> GetUfioRequestByDfc() NN_NOEXCEPT
{
    // nn::sf::UnmanagedServiceObject の場合は GetShared() メソッドで共有ポインタを取得することができます。
    return g_UfioRequest.GetShared();
}

}}
