﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace ldn { namespace detail
{
    char ConvertToHexChar(int n) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_MINMAX(n, 0x00, 0x0F);
        if (0 <= n && n <= 9)
        {
            return static_cast<char>('0' + n);
        }
        else
        {
            return static_cast<char>('a' + (n - 10));
        }
    }

    size_t ConvertToHexString(void* outBuffer, size_t bufferSize,
                              const void* input, size_t inputSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(outBuffer);
        NN_SDK_ASSERT_NOT_NULL(input);
        NN_SDK_ASSERT(inputSize * 2 + 1 <= bufferSize);
        if (inputSize * 2 + 1 <= bufferSize)
        {
            auto out = static_cast<char*>(outBuffer);
            auto in  = static_cast<const Bit8*>(input);
            for (size_t i = 0; i < inputSize; ++i)
            {
                auto high = (in[i] >> 4) & 0x0F;
                auto low  = in[i] & 0x0F;
                out[i * 2 + 0] = ConvertToHexChar(high);
                out[i * 2 + 1] = ConvertToHexChar(low);
            }
            out[inputSize * 2] = 0;
            return inputSize * 2;
        }
        else
        {
            return 0;
        }
    }

}}} // namespace nn::ldn::detail
