﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_Random.h>
#include <nn/util/util_TinyMt.h>

namespace nn { namespace ldn { namespace detail { namespace
{
    class RandomEngineImpl
    {
    public:

        RandomEngineImpl() NN_NOEXCEPT
        {
            Bit32 seedSource;
            nn::os::GenerateRandomBytes(&seedSource, sizeof(seedSource));
            m_Engine.Initialize(seedSource);
        }

        Bit32 Generate() NN_NOEXCEPT
        {
            return m_Engine.GenerateRandomU32();
        }

    private:

        nn::util::TinyMt m_Engine;
    };

    RandomEngineImpl g_RandomEngine;

}}}} // namespace nn::ldn::detail::<unnamed>

namespace nn { namespace ldn { namespace detail { namespace impl
{
    Bit32 RandomEngine() NN_NOEXCEPT
    {
        return g_RandomEngine.Generate();
    }

}}}} // namespace nn::ldn::detail::impl

namespace nn { namespace ldn { namespace detail
{
    void FillRandom(void* out, size_t size) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(out);
        auto start = reinterpret_cast<uintptr_t>(out);
        auto cur = start;
        while (!nn::util::is_aligned(cur, sizeof(Bit32)) && (cur - start) < size)
        {
            *reinterpret_cast<Bit8*>(cur) = static_cast<Bit8>(impl::RandomEngine());
            ++cur;
        }
        while ((cur - start + sizeof(Bit32)) <= size)
        {
            *reinterpret_cast<Bit32*>(cur) = impl::RandomEngine();
            cur += sizeof(Bit32);
        }
        while ((cur - start) < size)
        {
            *reinterpret_cast<Bit8*>(cur) = static_cast<Bit8>(impl::RandomEngine());
            ++cur;
        }
        NN_SDK_ASSERT_EQUAL(size, static_cast<size_t>(cur - start));
    }

}}} // namespace nn::ldn::detail
