﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/crypto/crypto_Sha256Generator.h>

namespace nn { namespace ldn { namespace detail { namespace
{
    const size_t Sha256DigestSize = 32;

}}}} // namespace nn::ldn::detail::<unnamed>

namespace nn { namespace ldn { namespace detail
{
    void CalculateSha256(
        void* outHash, size_t* outHashSize, size_t bufferSize,
        const void* data, size_t dataSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(outHash);
        NN_SDK_ASSERT_NOT_NULL(outHashSize);
        NN_SDK_ASSERT(Sha256DigestSize <= bufferSize);
        nn::crypto::GenerateSha256Hash(outHash, bufferSize, data, dataSize);
        *outHashSize = Sha256DigestSize;
    }

}}} // namespace nn::ldn::detail
