﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <nn/nn_Common.h>
#include <nn/ldn/ldn_Ipv4Address.h>
#include <nn/ldn/detail/Debug/ldn_Assert.h>
#include <nn/ldn/detail/TcpIp/ldn_TcpIpStackConfigurationImpl-os.win.h>
#include <nn/ldn/detail/Utility/ldn_ReverseByteOrder.h>

namespace nn { namespace ldn { namespace detail { namespace impl
{
    TcpIpStackConfigurationImpl::TcpIpStackConfigurationImpl() NN_NOEXCEPT
        : m_IsStarted(false)
    {
    }

    TcpIpStackConfigurationImpl::~TcpIpStackConfigurationImpl() NN_NOEXCEPT
    {
        if (m_IsStarted)
        {
            Down();
        }
    }

    void TcpIpStackConfigurationImpl::Startup(
        Ipv4Address address, Ipv4Address gateway, SubnetMask mask,
        const NetworkInterfaceProfile& profile) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(!m_IsStarted, "TCP/IP stack has already been initialized");
        NN_SDK_ASSERT_NOT_EQUAL(ZeroIpv4Address, address);
        NN_SDK_ASSERT_NOT_EQUAL(BroadcastIpv4Address, address);
        NN_SDK_ASSERT_NOT_EQUAL(ZeroIpv4Address, gateway);
        NN_SDK_ASSERT_NOT_EQUAL(BroadcastIpv4Address, gateway);
        NN_UNUSED(address);
        NN_UNUSED(gateway);
        NN_UNUSED(mask);
        NN_UNUSED(profile);
        m_IsStarted = true;
    }

    void TcpIpStackConfigurationImpl::Down() NN_NOEXCEPT
    {
         NN_SDK_ASSERT(m_IsStarted, "TCP/IP stack has yet to be initialized");
         m_IsStarted = false;
    }

    void TcpIpStackConfigurationImpl::AddEntry(Ipv4Address ip, MacAddress mac) NN_NOEXCEPT
    {
        NN_UNUSED(ip);
        NN_UNUSED(mac);
    }

    void TcpIpStackConfigurationImpl::RemoveEntry(Ipv4Address ip) NN_NOEXCEPT
    {
        NN_UNUSED(ip);
    }

    void TcpIpStackConfigurationImpl::ClearEntry() NN_NOEXCEPT
    {
    }

}}}} // namespace nn::ldn::detail
