﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lcs/lcs_DebugApi.h>
#include <nn/lcs/detail/lcs_Resource.h>
#include <nn/lcs/detail/lcs_Version.h>

namespace nn { namespace lcs {

    int g_MajorVersion = detail::CurrentMajorVersion;
    int g_MinorVersion = detail::CurrentMinorVersion;

    // nn::ns::AsyncResult から取得する ErrorContext 保存用
    nn::err::ErrorContext g_ErrorContext;

    void SetMajorVersion(int major) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(major, 0, 16);

        g_MajorVersion = major;
    }

    void SetMinorVersion(int minor) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(minor, 0, 16);

        g_MinorVersion = minor;
    }

    int GetMajorVersion() NN_NOEXCEPT
    {
        return g_MajorVersion;
    }

    int GetMinorVersion() NN_NOEXCEPT
    {
        return g_MinorVersion;
    }

    void SetErrorContext(const nn::err::ErrorContext& errorContex) NN_NOEXCEPT
    {
        g_ErrorContext = errorContex;
    }

    void GetErrorContext(nn::err::ErrorContext* pOutErrorContex) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pOutErrorContex);

        *pOutErrorContex = g_ErrorContext;

        ::std::memset(&g_ErrorContext, 0, sizeof(g_ErrorContext));
    }

}} // namespace nn::lcs
