﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hidbus/system/hidbus_Applet.h>

#include "detail/hidbus_AppletImpl.h"

namespace nn { namespace hidbus { namespace system {

void SetAppletResourceUserId(const ::nn::applet::AppletResourceUserId& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hidbus::detail::SetAppletResourceUserId(value));
}

void RegisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid,
    ::nn::applet::AppletId appletId) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hidbus::detail::RegisterAppletResourceUserId(aruid, appletId));
}

void UnregisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hidbus::detail::UnregisterAppletResourceUserId(aruid));
}

}}} // namespace nn::hidbus::system
