﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include <nn/hidbus/hidbus.h>

#include "hidbus_InternalDefinition.h"

namespace nn { namespace hidbus { namespace detail {

inline int GetInternalIndexFromHandle(const nn::hidbus::BusHandle& handle) NN_NOEXCEPT
{
    uint32_t upperHandle = static_cast<uint32_t>(handle._storage >> 32);
    // 下位 8bit だけ抜き出す
    auto index = static_cast<int>(upperHandle & 255);
    NN_ABORT_UNLESS_LESS_EQUAL(index, MaxHidbusNumber);
    return index;
}

}}} // namespace nn::hidbus::detail
