﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <nn/hid/hid_ExternalBus.h>
#include <nn/hid/hid_ResultPrivate.h>

#include <nn/hidbus/hidbus_Result.h>
#include <nn/hidbus/server/hidbus_HidbusSystemServer.h>

#include "../server/hidbus_StaticObject.h"

namespace nn { namespace hidbus { namespace detail {

::nn::Result CreateHidbusSystemServerProxy(::nn::sf::SharedPointer<IHidbusSystemServer>* outValue) NN_NOEXCEPT
{
    *outValue = nn::hidbus::detail::StaticObject<
        ::nn::sf::UnmanagedServiceObject<IHidbusSystemServer, nn::hidbus::server::HidbusSystemServer>
    >::Get().GetShared();
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hidbus::detail
