﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.bluetooth
{
    [CppRefPath(@"<nn/bluetooth/bluetooth_AddressTypes.h>")]
    [ExternalStruct(6, 1)]
    public struct Address
    {
    }
}

namespace nn.xcd
{
    [CppRefPath(@"<nn/xcd/xcd_Device.h>")]
    [ExternalStruct(8, 8)]
    public struct DeviceHandle
    {
    }
}

namespace nn.hidbus
{
    [CppRefPath("<nn/hidbus/hidbus_IHidbusSystemServer.sfdl.h>")]
    public interface IHidbusSystemServer : IServiceObject
    {
    }
}

namespace nn.util
{
    [CppRefPath("<nn/util/util_MathTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct Color4u8Type
    {
    }
}

namespace nn.hid
{
    [CppRefPath(@"<nn/hid/hid_NpadCommonTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct NpadIdType
    {
    }

    [CppRefPath(@"<nn/hid/hid_NpadCommonTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct NpadStyleSet
    {
    }

    [CppRefPath(@"<nn/hid/hid_AnalogStickState.h>")]
    [ExternalStruct(8, 4)]
    public struct AnalogStickState
    {
    }

    namespace system
    {
        [CppRefPath(@"<nn/hid/system/hid_Keyboard.h>")]
        [ExternalStruct(4, 4)]
        public struct KeyboardLockKeyEventSet
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_NpadCommon.h>")]
        [ExternalStruct(4, 4)]
        public struct NpadDeviceTypeSet
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_PlayReport.h>")]
        [ExternalStruct(20, 4)]
        public struct PlayReportControllerUsage
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_RegisteredDevice.h>")]
        [ExternalStruct(48, 8)]
        public struct RegisteredDeviceOld
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_RegisteredDevice.h>")]
        [ExternalStruct(104, 8)]
        public struct RegisteredDevice
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_AudioControl.h>")]
        [ExternalStruct(16, 8)]
        public struct AudioControlState
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_UniquePad.h>")]
        [ExternalStruct(16, 8)]
        public struct UniquePadSerialNumber
        {
        }
    }

    [CppRefPath(@"<nn/hid/hid_IHidSystemServer.sfdl.h>")]
    public interface IHidSystemServer : IServiceObject
    {
        [MethodId(31)]
        Result SendKeyboardLockKeyEvent(system.KeyboardLockKeyEventSet value);

        [MethodId(101)]
        Result AcquireHomeButtonEventHandle(
            Out<NativeHandle> outValue, nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(111)]
        Result ActivateHomeButton(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(121)]
        Result AcquireSleepButtonEventHandle(
            Out<NativeHandle> outValue, nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(131)]
        Result ActivateSleepButton(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(141)]
        Result AcquireCaptureButtonEventHandle(
            Out<NativeHandle> outValue, nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(151)]
        Result ActivateCaptureButton(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(210)]
        Result AcquireNfcDeviceUpdateEventHandle(Out<NativeHandle> outValue);

        [MethodId(211)]
        Result GetNpadsWithNfc(Out<int64_t> outCount,
                               OutArray<NpadIdType> outIds);

        [MethodId(212)]
        Result AcquireNfcActivateEventHandle(Out<NativeHandle> outValue, NpadIdType id);

        [MethodId(213)]
        Result ActivateNfc(NpadIdType id, bool activate, nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(214)]
        Result GetXcdHandleForNpadWithNfc(Out<nn.xcd.DeviceHandle> outHandle, NpadIdType id, nn.applet.AppletResourceUserId aruid);

        [MethodId(215)]
        Result IsNfcActivated(Out<bool> outIsActivated, NpadIdType id);

        [MethodId(230)]
        Result AcquireIrSensorEventHandle(Out<NativeHandle> outValue, NpadIdType id);

        [MethodId(231)]
        Result ActivateIrSensor(NpadIdType id, bool activate, nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(322)]
        Result GetIrSensorState(NpadIdType id, Out<int64_t> outValue, nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(323)]
        Result GetXcdHandleForNpadWithIrSensor(NpadIdType id, Out<nn.xcd.DeviceHandle> outHandle, nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(301)]
        Result ActivateNpadSystem(NpadIdType id);

        [MethodId(303)]
        Result ApplyNpadSystemCommonPolicy(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(304)]
        Result EnableAssigningSingleOnSlSrPress(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(305)]
        Result DisableAssigningSingleOnSlSrPress(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(306)]
        Result GetLastActiveNpad(Out<nn.hid.NpadIdType> outValue);

        [MethodId(307)]
        Result GetNpadSystemExtStyle(Out<int64_t> outMainStyle,
                                     Out<int64_t> outSubStyle,
                                     nn.hid.NpadIdType npadId);

        [MethodId(308)]
        Result ApplyNpadSystemCommonPolicyFull(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(309)]
        Result GetNpadFullKeyGripColor(Out<nn.util.Color4u8Type> outLeftGrip,
                                       Out<nn.util.Color4u8Type> outRightGrip,
                                       nn.hid.NpadIdType npadId);

        [MethodId(310)]
        Result GetMaskedSupportedNpadStyleSet(Out<nn.hid.NpadStyleSet> outValue,
                                              nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(311)]
        Result SetNpadPlayerLedBlinkingDevice(nn.applet.CheckedAppletResourceUserId aruid, nn.hid.NpadIdType npadId, nn.hid.system.NpadDeviceTypeSet deviceType);

        [MethodId(321)]
        Result GetUniquePadsFromNpad(Out<int64_t> outGotCount, OutArray<nn.hid.system.UniquePadId> outIds, nn.hid.NpadIdType npadId);

        [MethodId(500)]
        Result SetAppletResourceUserId(nn.applet.AppletResourceUserId value);

        [MethodId(501)]
        Result RegisterAppletResourceUserId(
            nn.applet.AppletResourceUserId aruid, bool enablesInput);

        [MethodId(502)]
        Result UnregisterAppletResourceUserId(
            nn.applet.AppletResourceUserId aruid);

        [MethodId(503)]
        Result EnableAppletToGetInput(
            nn.applet.AppletResourceUserId aruid, bool enablesInput);

        [MethodId(504)]
        Result SetAruidValidForVibration(
            nn.applet.AppletResourceUserId aruid, bool enable);

        [MethodId(505)]
        Result EnableAppletToGetSixAxisSensor(
            nn.applet.AppletResourceUserId aruid, bool enablesInput);

        [MethodId(510)]
        Result SetVibrationMasterVolume(float value);

        [MethodId(511)]
        Result GetVibrationMasterVolume(Out<float> outValue);

        [MethodId(512)]
        Result BeginPermitVibrationSession(
            nn.applet.AppletResourceUserId aruid);

        [MethodId(513)]
        Result EndPermitVibrationSession();

        [MethodId(520)]
        Result EnableHandheldHids();

        [MethodId(521)]
        Result DisableHandheldHids();

        [MethodId(540)]
        Result AcquirePlayReportControllerUsageUpdateEvent(Out<NativeHandle> outValue);

        [MethodId(541)]
        Result GetPlayReportControllerUsages(Out<int64_t> outGotCount,
                                             OutArray<nn.hid.system.PlayReportControllerUsage> outValues);

        [MethodId(542)]
        Result AcquirePlayReportRegisteredDeviceUpdateEvent(Out<NativeHandle> outValue);

        [MethodId(543)]
        Result GetRegisteredDevicesOld(Out<int64_t> outGotCount,
                                       OutArray<nn.hid.system.RegisteredDeviceOld> outValues);

        [MethodId(544)]
        Result AcquireConnectionTriggerTimeoutEvent(Out<NativeHandle> outValue);

        [MethodId(545)]
        Result SendConnectionTrigger(nn.bluetooth.Address address);

        [MethodId(546)]
        Result AcquireDeviceRegisteredEventForControllerSupport(Out<NativeHandle> outValue);

        [MethodId(547)]
        Result GetAllowedBluetoothLinksCount(Out<int64_t> outValue);

        [MethodId(548)]
        Result GetRegisteredDevices(Out<int64_t> outGotCount,
                                    [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.hid.system.RegisteredDevice> outValues);

        [MethodId(549)]
        Result GetConnectableRegisteredDevices(Out<int64_t> outGotCount,
                                              [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.hid.system.RegisteredDevice> outValues);

        [MethodId(700)]
        Result ActivateUniquePad(nn.applet.CheckedAppletResourceUserId aruid,
                                 nn.hid.system.UniquePadId id);

        [MethodId(702)]
        Result AcquireUniquePadConnectionEventHandle(Out<NativeHandle> outValue);

        [MethodId(703)]
        Result GetUniquePadIds(Out<int64_t> outGotCount,
                               OutArray<nn.hid.system.UniquePadId> outUniquePadIds);

        [MethodId(751)]
        Result AcquireJoyDetachOnBluetoothOffEventHandle(Out<NativeHandle> outValue, nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(800)]
        Result ListSixAxisSensorHandles(Out<int64_t> outGotCount,
                                        OutArray<nn.hid.system.UniqueSixAxisSensorHandle> outUniqueSixAxisSensorHandles,
                                        nn.hid.system.UniquePadId id);
        [MethodId(801)]
        Result IsSixAxisSensorUserCalibrationSupported(Out<bool> outIsSupported,
                                                       nn.hid.system.UniqueSixAxisSensorHandle handle);

        [MethodId(802)]
        Result ResetSixAxisSensorCalibrationValues(nn.hid.system.UniqueSixAxisSensorHandle handle);

        [MethodId(803)]
        Result StartSixAxisSensorUserCalibration(nn.hid.system.UniqueSixAxisSensorHandle handle);

        [MethodId(804)]
        Result CancelSixAxisSensorUserCalibration(nn.hid.system.UniqueSixAxisSensorHandle handle);

        [MethodId(805)]
        Result GetUniquePadBluetoothAddress(Out<nn.bluetooth.Address> outGotAddress,
                                            nn.hid.system.UniquePadId id);

        [MethodId(806)]
        Result DisconnectUniquePad(nn.hid.system.UniquePadId id);

        [MethodId(807)]
        Result GetUniquePadType(Out<int64_t> outValue,
                                nn.hid.system.UniquePadId id);

        [MethodId(808)]
        Result GetUniquePadInterface(Out<int64_t> outValue,
                                     nn.hid.system.UniquePadId id);

        [MethodId(809)]
        Result GetUniquePadSerialNumber(Out<nn.hid.system.UniquePadSerialNumber> outValue,
                                        nn.hid.system.UniquePadId id);

        [MethodId(810)]
        Result GetUniquePadControllerNumber(Out<int64_t> outValue,
                                            nn.hid.system.UniquePadId id);

        [MethodId(811)]
        Result GetSixAxisSensorUserCalibrationStage(Out<int64_t> outValue,
                                                    nn.hid.system.UniqueSixAxisSensorHandle handle);

        [MethodId(821)]
        Result StartAnalogStickManualCalibration(nn.hid.system.UniquePadId id,
                                                 int64_t position);

        [MethodId(822)]
        Result RetryCurrentAnalogStickManualCalibrationStage(nn.hid.system.UniquePadId id,
                                                             int64_t position);

        [MethodId(823)]
        Result CancelAnalogStickManualCalibration(nn.hid.system.UniquePadId id,
                                                  int64_t position);

        [MethodId(824)]
        Result ResetAnalogStickManualCalibration(nn.hid.system.UniquePadId id,
                                                 int64_t position);

        [MethodId(825)]
        Result GetAnalogStickState(Out<nn.hid.AnalogStickState> outValue,
                                   nn.hid.system.UniquePadId id,
                                   int64_t position);

        [MethodId(826)]
        Result GetAnalogStickManualCalibrationStage(Out<int64_t> outValue,
                                                    nn.hid.system.UniquePadId id,
                                                    int64_t position);

        [MethodId(827)]
        Result IsAnalogStickButtonPressed(Out<bool> outValue,
                                          nn.hid.system.UniquePadId id,
                                          int64_t position);

        [MethodId(828)]
        Result IsAnalogStickInReleasePosition(Out<bool> outValue,
                                              nn.hid.system.UniquePadId id,
                                              int64_t position);

        [MethodId(829)]
        Result IsAnalogStickInCircumference(Out<bool> outValue,
                                            nn.hid.system.UniquePadId id,
                                            int64_t position);

        [MethodId(850)]
        Result IsUsbFullKeyControllerEnabled(Out<bool> outIsEnabled);

        [MethodId(851)]
        Result EnableUsbFullKeyController(bool enabled);

        [MethodId(852)]
        Result IsUsbConnected(Out<bool> outIsConnected, nn.hid.system.UniquePadId id);

        [MethodId(870)]
        Result IsHandheldButtonPressedOnConsoleMode(Out<bool> outValue);

        [MethodId(900)]
        Result ActivateInputDetector(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(901)]
        Result NotifyInputDetector(nn.hid.system.InputSourceIdSet id);

        [MethodId(1000)]
        Result InitializeFirmwareUpdate();

        [MethodId(1001)]
        Result GetFirmwareVersion(
            Out<nn.hid.system.FirmwareVersion> outValue,
            nn.hid.system.UniquePadId id);

        [MethodId(1002)]
        Result GetAvailableFirmwareVersion(
            Out<nn.hid.system.FirmwareVersion> outValue,
            nn.hid.system.UniquePadId id);

        [MethodId(1003)]
        Result IsFirmwareUpdateAvailable(
            Out<bool> outIsAvailable,
            nn.hid.system.UniquePadId id);

        [MethodId(1004)]
        Result CheckFirmwareUpdateRequired(
            Out<int64_t> outReason,
            nn.hid.system.UniquePadId id);

        [MethodId(1005)]
        Result StartFirmwareUpdate(
            Out<nn.hid.system.FirmwareUpdateDeviceHandle> outHandle,
            nn.hid.system.UniquePadId id);

        [MethodId(1006)]
        Result AbortFirmwareUpdate();

        [MethodId(1007)]
        Result GetFirmwareUpdateState(
            Out<nn.hid.system.FirmwareUpdateState> outState,
            nn.hid.system.FirmwareUpdateDeviceHandle handle);

        [MethodId(1008)]
        Result ActivateAudioControl();

        [MethodId(1009)]
        Result AcquireAudioControlEventHandle(
            Out<NativeHandle> outValue);

        [MethodId(1010)]
        Result GetAudioControlStates(
            Out<int64_t> outCount,
            OutArray<system.AudioControlState> outStates);

        [MethodId(1011)]
        Result DeactivateAudioControl();

        [MethodId(1050)]
        Result IsSixAxisSensorAccurateUserCalibrationSupported(Out<bool> outIsSupported,
        	                                                   nn.hid.system.UniqueSixAxisSensorHandle handle,
                                                               nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(1051)]
        Result StartSixAxisSensorAccurateUserCalibration(nn.hid.system.UniqueSixAxisSensorHandle handle,
        	                                             nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(1052)]
        Result CancelSixAxisSensorAccurateUserCalibration(nn.hid.system.UniqueSixAxisSensorHandle handle,
        	                                              nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(1053)]
        Result GetSixAxisSensorAccurateUserCalibrationState(Out<nn.hid.system.SixAxisSensorAccurateUserCalibrationState> outState,
                                                            nn.hid.system.UniqueSixAxisSensorHandle handle,
                                                            nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(1100)]
        Result GetHidbusSystemServiceObject(Out<nn.hidbus.IHidbusSystemServer> outService);

        [MethodId(1120)]
        Result SetFirmwareHotfixUpdateSkipEnabled(bool isEnabled);

    }
}

namespace nn.hid.system
{
    [CppRefPath(@"<nn/hid/system/hid_UniquePad.h>")]
    [ExternalStruct(8, 8)]
    public struct UniquePadId
    {
    }

    [CppRefPath(@"<nn/hid/system/hid_SixAxisSensorCalibration.h>")]
    [ExternalStruct(4, 4)]
    public struct UniqueSixAxisSensorHandle
    {
    }

    [CppRefPath(@"<nn/hid/system/hid_SixAxisSensorAccurateCalibration.h>")]
    [ExternalStruct(8, 4)]
    public struct SixAxisSensorAccurateUserCalibrationState
    {
    }

    [CppRefPath(@"<nn/hid/system/hid_InputDetection.h>")]
    [ExternalStruct(4, 4)]
    public struct InputSourceIdSet
    {
    }

    [CppRefPath(@"<nn/hid/system/hid_FirmwareUpdate.h>")]
    [ExternalStruct(16, 1)]
    public struct FirmwareVersion
    {
    }

    [CppRefPath(@"<nn/hid/system/hid_FirmwareUpdate.h>")]
    [ExternalStruct(8, 8)]
    public struct FirmwareUpdateDeviceHandle
    {
    }

    [CppRefPath(@"<nn/hid/system/hid_FirmwareUpdate.h>")]
    [ExternalStruct(4, 1)]
    public struct FirmwareUpdateState
    {
    }
}
