﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.hid.system
{
    [CppRefPath(@"<nn/hid/system/hid_CommonTypes.h>")]
    [ExternalStruct(1, 1)]
    public struct InterfaceType
    {
    }
}

namespace nn.hid
{
    [CppRefPath(@"<nn/hid/hid_Xpad.h>")]
    [ExternalStruct(4, 4)]
    public struct BasicXpadId
    {
    }

    [CppRefPath(@"<nn/hid/hid_JoyXpad.h>")]
    [ExternalStruct(4, 4)]
    public struct JoyXpadId
    {
    }

    [CppRefPath(@"<nn/hid/hid_VibrationTypesForIpc.h>")]
    [ExternalStruct(8, 4)]
    public struct VibrationDeviceInfoForIpc
    {
    }

    [CppRefPath(@"<nn/hid/hid_VibrationDeviceApi.h>")]
    [ExternalStruct(4, 4)]
    public struct VibrationDeviceHandle
    {
    }

    [CppRefPath(@"<nn/hid/hid_VibrationValueTypes.h>")]
    [ExternalStruct(16, 4)]
    public struct VibrationValue
    {
    }

    [CppRefPath(@"<nn/hid/hid_VibrationGcErm.h>")]
    [ExternalStruct(8, 8)]
    public struct VibrationGcErmCommand
    {
    }


    [CppRefPath(@"<nn/hid/hid_SixAxisSensor.h>")]
    [ExternalStruct(4, 4)]
    public struct SixAxisSensorHandle
    {
    }

    [CppRefPath(@"<nn/hid/hid_NpadCommonTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct NpadIdType
    {
    }

    [CppRefPath(@"<nn/hid/hid_NpadCommonTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct NpadStyleSet
    {
    }

    [CppRefPath(@"<nn/hid/hid_ConsoleSixAxisSensor.h>")]
    [ExternalStruct(4, 4)]
    public struct ConsoleSixAxisSensorHandle
    {
    }

    [CppRefPath(@"<nn/hid/hid_PalmaTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct PalmaConnectionHandle
    {
    }

    [CppRefPath(@"<nn/hid/hid_PalmaTypes.h>")]
    [LargeData]
    [ExternalStruct(256, 4)]
    public struct PalmaApplicationSectionAccessBuffer
    {
    }

    [CppRefPath(@"<nn/hid/hid_PalmaTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct PalmaFeatureSet
    {
    }

    [CppRefPath(@"<nn/hid/hid_IHidServer.sfdl.h>")]
    public interface IAppletResource : IServiceObject
    {
        [MethodId(0)]
        Result GetSharedMemoryHandle(Out<NativeHandle> outValue);
    }

    [CppRefPath(@"<nn/hid/hid_IHidServer.sfdl.h>")]
    public interface IActiveVibrationDeviceList : IServiceObject
    {
        [MethodId(0)]
        Result ActivateVibrationDevice(nn.hid.VibrationDeviceHandle handle);
    }

    [CppRefPath(@"<nn/hid/hid_IHidServer.sfdl.h>")]
    public interface IHidServer : IServiceObject
    {
        [MethodId(0)]
        Result CreateAppletResource(Out<IAppletResource> outValue,
                                    nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(1)]
        Result ActivateDebugPad(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(11)]
        Result ActivateTouchScreen(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(21)]
        Result ActivateMouse(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(31)]
        Result ActivateKeyboard(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(40)]
        Result AcquireXpadIdEventHandle(Out<NativeHandle> outValue,
                                        uint64_t clientId);

        [MethodId(41)]
        Result ReleaseXpadIdEventHandle(uint64_t clientId);

        [MethodId(51)]
        Result ActivateXpad(nn.applet.CheckedAppletResourceUserId aruid,
                            BasicXpadId xpadId);

        [MethodId(55)]
        Result GetXpadIds(Out<int64_t> outCount,
                          OutArray<BasicXpadId> outXpadIds);

        [MethodId(56)]
        Result ActivateJoyXpad(JoyXpadId xpadId);

        [MethodId(58)]
        Result GetJoyXpadLifoHandle(Out<NativeHandle> outValue,
                                    JoyXpadId xpadId);

        [MethodId(59)]
        Result GetJoyXpadIds(Out<int64_t> outGotCount,
                             OutArray<JoyXpadId> outXpadIds);

        [MethodId(60)]
        Result ActivateSixAxisSensor(BasicXpadId xpadId);

        [MethodId(61)]
        Result DeactivateSixAxisSensor(BasicXpadId xpadId);

        [MethodId(62)]
        Result GetSixAxisSensorLifoHandle(Out<NativeHandle> outValue,
                                 BasicXpadId xpadId);

        [MethodId(63)]
        Result ActivateJoySixAxisSensor(JoyXpadId xpadId);

        [MethodId(64)]
        Result DeactivateJoySixAxisSensor(JoyXpadId xpadId);

        [MethodId(65)]
        Result GetJoySixAxisSensorLifoHandle(Out<NativeHandle> outValue,
                                             JoyXpadId xpadId);

        [MethodId(66)]
        Result StartSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid,
                                  SixAxisSensorHandle handle);

        [MethodId(67)]
        Result StopSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid,
                                 SixAxisSensorHandle handle);

        [MethodId(68)]
        Result IsSixAxisSensorFusionEnabled(Out<bool> outIsEnabled,
                                            nn.applet.CheckedAppletResourceUserId aruid,
                                            SixAxisSensorHandle handle);

        [MethodId(69)]
        Result EnableSixAxisSensorFusion(nn.applet.CheckedAppletResourceUserId aruid,
                                         SixAxisSensorHandle handle,
                                         bool enable);

        [MethodId(70)]
        Result SetSixAxisSensorFusionParameters(nn.applet.CheckedAppletResourceUserId aruid,
                                                SixAxisSensorHandle handle,
                                                float revisePower,
                                                float reviseRange);

        [MethodId(71)]
        Result GetSixAxisSensorFusionParameters(Out<float> outRevisePower,
                                                Out<float> outReviseRange,
                                                nn.applet.CheckedAppletResourceUserId aruid,
                                                SixAxisSensorHandle handle);

        [MethodId(72)]
        Result ResetSixAxisSensorFusionParameters(nn.applet.CheckedAppletResourceUserId aruid,
                                                  SixAxisSensorHandle handle);

        [MethodId(73)]
        Result SetAccelerometerParameters(nn.applet.CheckedAppletResourceUserId aruid,
                                          SixAxisSensorHandle handle,
                                          float playRadius,
                                          float sensitivity);

        [MethodId(74)]
        Result GetAccelerometerParameters(Out<float> outPlayRadius,
                                          Out<float> outSensitivity,
                                          nn.applet.CheckedAppletResourceUserId aruid,
                                          SixAxisSensorHandle handle);

        [MethodId(75)]
        Result ResetAccelerometerParameters(nn.applet.CheckedAppletResourceUserId aruid,
                                            SixAxisSensorHandle handle);

        [MethodId(76)]
        Result SetAccelerometerPlayMode(nn.applet.CheckedAppletResourceUserId aruid,
                                        SixAxisSensorHandle handle,
                                        uint32_t mode);

        [MethodId(77)]
        Result GetAccelerometerPlayMode(Out<uint32_t> outMode,
                                        nn.applet.CheckedAppletResourceUserId aruid,
                                        SixAxisSensorHandle handle);

        [MethodId(78)]
        Result ResetAccelerometerPlayMode(nn.applet.CheckedAppletResourceUserId aruid,
                                          SixAxisSensorHandle handle);

        [MethodId(79)]
        Result SetGyroscopeZeroDriftMode(nn.applet.CheckedAppletResourceUserId aruid,
                                         SixAxisSensorHandle handle,
                                         uint32_t mode);

        [MethodId(80)]
        Result GetGyroscopeZeroDriftMode(Out<uint32_t> outMode,
                                         nn.applet.CheckedAppletResourceUserId aruid,
                                         SixAxisSensorHandle handle);

        [MethodId(81)]
        Result ResetGyroscopeZeroDriftMode(nn.applet.CheckedAppletResourceUserId aruid,
                                           SixAxisSensorHandle handle);

        [MethodId(82)]
        Result IsSixAxisSensorAtRest(Out<bool> outIsAtRest,
                                     nn.applet.CheckedAppletResourceUserId aruid,
                                     SixAxisSensorHandle handle);

        [MethodId(91)]
        Result ActivateGesture(
            nn.applet.CheckedAppletResourceUserId aruid, int32_t version);

        [MethodId(100)]
        Result SetSupportedNpadStyleSet(nn.applet.CheckedAppletResourceUserId aruid, NpadStyleSet style);

        [MethodId(101)]
        Result GetSupportedNpadStyleSet(nn.applet.CheckedAppletResourceUserId aruid, Out<NpadStyleSet> outValue);

        [MethodId(102)]
        Result SetSupportedNpadIdType(nn.applet.CheckedAppletResourceUserId aruid, InArray<NpadIdType> ids);

        [MethodId(103)]
        Result ActivateNpad(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(104)]
        Result DeactivateNpad(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(106)]
        Result AcquireNpadStyleSetUpdateEventHandle(nn.applet.CheckedAppletResourceUserId aruid,
                                                    Out<NativeHandle> outValue,
                                                    NpadIdType id,
                                                    uint64_t clientId);

        [MethodId(107)]
        Result DisconnectNpad(nn.applet.CheckedAppletResourceUserId aruid, NpadIdType id);

        [MethodId(108)]
        Result GetPlayerLedPattern(Out<uint64_t> outValue, NpadIdType id);

        [MethodId(109)]
        Result ActivateNpadWithRevision(nn.applet.CheckedAppletResourceUserId aruid, int32_t revision);

        [MethodId(120)]
        Result SetNpadJoyHoldType(nn.applet.CheckedAppletResourceUserId aruid, int64_t holdType);

        [MethodId(121)]
        Result GetNpadJoyHoldType(nn.applet.CheckedAppletResourceUserId aruid, Out<int64_t> outValue);

        [MethodId(122)]
        Result SetNpadJoyAssignmentModeSingleByDefault(nn.applet.CheckedAppletResourceUserId aruid, NpadIdType id);

        [MethodId(123)]
        Result SetNpadJoyAssignmentModeSingle(nn.applet.CheckedAppletResourceUserId aruid, NpadIdType id, int64_t type);

        [MethodId(124)]
        Result SetNpadJoyAssignmentModeDual(nn.applet.CheckedAppletResourceUserId aruid, NpadIdType id);

        [MethodId(125)]
        Result MergeSingleJoyAsDualJoy(nn.applet.CheckedAppletResourceUserId aruid, NpadIdType id1, NpadIdType id2);

        [MethodId(126)]
        Result StartLrAssignmentMode(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(127)]
        Result StopLrAssignmentMode(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(128)]
        Result SetNpadHandheldActivationMode(nn.applet.CheckedAppletResourceUserId aruid, int64_t mode);

        [MethodId(129)]
        Result GetNpadHandheldActivationMode(nn.applet.CheckedAppletResourceUserId aruid, Out<int64_t> outValue);

        [MethodId(130)]
        Result SwapNpadAssignment(nn.applet.CheckedAppletResourceUserId aruid, NpadIdType id1, NpadIdType id2);

        [MethodId(131)]
        Result IsUnintendedHomeButtonInputProtectionEnabled(Out<bool> outIsEnabled, nn.applet.CheckedAppletResourceUserId aruid, NpadIdType id);

        [MethodId(132)]
        Result EnableUnintendedHomeButtonInputProtection(nn.applet.CheckedAppletResourceUserId aruid, NpadIdType id, bool enabled);

        [MethodId(133)]
        Result SetNpadJoyAssignmentModeSingleWithDestination(Out<bool> outIsAssigned, Out<NpadIdType> outId, nn.applet.CheckedAppletResourceUserId aruid, NpadIdType id, int64_t type);

        [MethodId(200)]
        Result GetVibrationDeviceInfo(Out<VibrationDeviceInfoForIpc> outValue,
                               VibrationDeviceHandle handle);

        [MethodId(201)]
        Result SendVibrationValue(nn.applet.CheckedAppletResourceUserId aruid,
                                  VibrationDeviceHandle handle,
                                  VibrationValue value);

        [MethodId(202)]
        Result GetActualVibrationValue(Out<VibrationValue> outValue,
                                       nn.applet.CheckedAppletResourceUserId aruid,
                                       VibrationDeviceHandle handle);

        [MethodId(203)]
        Result CreateActiveVibrationDeviceList(Out<IActiveVibrationDeviceList> outValue);

        [MethodId(204)]
        Result PermitVibration(bool isPermitted);

        [MethodId(205)]
        Result IsVibrationPermitted(Out<bool> outValue);

        [MethodId(206)]
        Result SendVibrationValues(nn.applet.AppletResourceUserId aruid,
                                   InArray<VibrationDeviceHandle> handles,
                                   InArray<VibrationValue> values);

        [MethodId(207)]
        Result SendVibrationGcErmCommand(nn.applet.CheckedAppletResourceUserId aruid,
                                  VibrationDeviceHandle handle,
                                  VibrationGcErmCommand command);

        [MethodId(208)]
        Result GetActualVibrationGcErmCommand(Out<VibrationGcErmCommand> outValue,
                                       nn.applet.CheckedAppletResourceUserId aruid,
                                       VibrationDeviceHandle handle);
        [MethodId(209)]
        Result BeginPermitVibrationSession(
            nn.applet.AppletResourceUserId aruid);

        [MethodId(210)]
        Result EndPermitVibrationSession();

        [MethodId(300)]
        Result ActivateConsoleSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(301)]
        Result StartConsoleSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid,
                                         ConsoleSixAxisSensorHandle handle);

        [MethodId(302)]
        Result StopConsoleSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid,
                                        ConsoleSixAxisSensorHandle handle);

        [MethodId(303)]
        Result ActivateSevenSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(304)]
        Result StartSevenSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(305)]
        Result StopSevenSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(306)]
        Result InitializeSevenSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid,
                                            NativeHandle stateBufferHandle,
                                            uint64_t stateBufferSize,
                                            NativeHandle workBufferHandle,
                                            uint64_t workBufferSize);

        [MethodId(307)]
        Result FinalizeSevenSixAxisSensor(nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(308)]
        Result SetSevenSixAxisSensorFusionStrength(nn.applet.CheckedAppletResourceUserId aruid,
                                                   float strength);

        [MethodId(309)]
        Result GetSevenSixAxisSensorFusionStrength(Out<float> strength,
                                                   nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(400)]
        Result IsUsbFullKeyControllerEnabled(Out<bool> outIsEnabled);

        [MethodId(401)]
        Result EnableUsbFullKeyController(bool enabled);

        [MethodId(402)]
        Result IsUsbFullKeyControllerConnected(Out<bool> outIsConnected, NpadIdType id);

        [MethodId(403)]
        Result HasBattery(Out<bool> outHasBattery, NpadIdType id);

        [MethodId(404)]
        Result HasLeftRightBattery(Out<bool> outLeftJoyHasBattery, Out<bool> outRightJoyHasBattery, NpadIdType id);

        [MethodId(405)]
        Result GetNpadInterfaceType(Out<nn.hid.system.InterfaceType> outInterfaceType, NpadIdType id);

        [MethodId(406)]
        Result GetNpadLeftRightInterfaceType(Out<nn.hid.system.InterfaceType> outLeftJoyInterfaceType, Out<nn.hid.system.InterfaceType> outRightJoyInterfaceType, NpadIdType id);

        [MethodId(500)]
        Result GetPalmaConnectionHandle(Out<PalmaConnectionHandle> outHandle, NpadIdType id, nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(501)]
        Result InitializePalma(PalmaConnectionHandle handle);

        [MethodId(502)]
        Result AcquirePalmaOperationCompleteEvent(Out<NativeHandle> outValue,
                                                  PalmaConnectionHandle handle);
        [MethodId(503)]
        Result GetPalmaOperationInfo(Out<uint64_t> outType,
                                     nn.sf.OutBuffer outBuffer,
                                     PalmaConnectionHandle handle);

        [MethodId(504)]
        Result PlayPalmaActivity(PalmaConnectionHandle handle, uint64_t index);

        [MethodId(505)]
        Result SetPalmaFrModeType(PalmaConnectionHandle handle, uint64_t type);

        [MethodId(506)]
        Result ReadPalmaStep(PalmaConnectionHandle handle);

        [MethodId(507)]
        Result EnablePalmaStep(PalmaConnectionHandle handle, bool isEnabled);

        [MethodId(508)]
        Result ResetPalmaStep(PalmaConnectionHandle handle);

        [MethodId(509)]
        Result ReadPalmaApplicationSection(PalmaConnectionHandle handle,
                                      uint64_t address,
                                      uint64_t size);

        [MethodId(510)]
        Result WritePalmaApplicationSection(PalmaConnectionHandle handle,
                                       uint64_t address,
                                       uint64_t size,
                                       PalmaApplicationSectionAccessBuffer buffer);

        [MethodId(511)]
        Result ReadPalmaUniqueCode(PalmaConnectionHandle handle);

        [MethodId(512)]
        Result SetPalmaUniqueCodeInvalid(PalmaConnectionHandle handle);

        [MethodId(513)]
        Result WritePalmaActivityEntry(PalmaConnectionHandle handle, uint64_t index, uint64_t ledIndex, uint64_t waveSet, uint64_t waveIndex);

        [MethodId(514)]
        Result WritePalmaRgbLedPatternEntry(PalmaConnectionHandle handle, uint64_t index, InBuffer pInBuffer);

        [MethodId(515)]
        Result WritePalmaWaveEntry(PalmaConnectionHandle handle, uint64_t waveSet, uint64_t index, NativeHandle transferMemoryHandle, uint64_t transferMemorySize, uint64_t waveDataSize);

        [MethodId(516)]
        Result SetPalmaDataBaseIdentificationVersion(PalmaConnectionHandle handle, int32_t version);

        [MethodId(517)]
        Result GetPalmaDataBaseIdentificationVersion(PalmaConnectionHandle handle);

        [MethodId(518)]
        Result SuspendPalmaFeature(PalmaConnectionHandle handle, PalmaFeatureSet suspendFeatureSet);

        [MethodId(519)]
        Result GetPalmaOperationResult(PalmaConnectionHandle handle);

        [MethodId(520)]
        Result ReadPalmaPlayLog(PalmaConnectionHandle handle, uint16_t index);

        [MethodId(521)]
        Result ResetPalmaPlayLog(PalmaConnectionHandle handle, uint16_t index);

        [MethodId(522)]
        Result SetIsPalmaAllConnectable(nn.applet.CheckedAppletResourceUserId aruid, bool connectable);

        [MethodId(523)]
        Result SetIsPalmaPairedConnectable(nn.applet.CheckedAppletResourceUserId aruid, bool connectable);

        [MethodId(524)]
        Result PairPalma(PalmaConnectionHandle handle);

        [MethodId(525)]
        Result SetPalmaBoostMode(bool enabled);

        [MethodId(1000)]
        Result SetNpadCommunicationMode(nn.applet.CheckedAppletResourceUserId aruid,
                                        int64_t mode);

        [MethodId(1001)]
        Result GetNpadCommunicationMode(Out<int64_t> outValue);
    }
}
