﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/hid_VibrationWriter.h>

namespace nn { namespace hid {

VibrationWriter::VibrationWriter() NN_NOEXCEPT {}

VibrationWriter::~VibrationWriter() NN_NOEXCEPT {}

void VibrationWriter::Write(const VibrationValue& value) NN_NOEXCEPT
{
    SetCurrentVibration(value);
}

void VibrationWriter::OnNextSampleRequired(
    VibrationValue* pValue,
    VibrationNodeConnection::List* pInputConnections) NN_NOEXCEPT
{
    NN_UNUSED(pValue);          // ここでは振動値を更新しません
    NN_UNUSED(pInputConnections);    // 接続元の振動値は利用しません
}

}} // namespace nn::hid
