﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   コントローラーサポートの UI 呼び出しに関する API の定義
 */

#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_ControllerSupport.h>

#include "detail/hid_ControllerSupportImpl.h"

//---------------------------------------------------------------------------
// C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace hid {

//---------------------------------------------------------------------------
//
void ShowControllerStrapGuideForPalma() NN_NOEXCEPT
{
    system::ControllerSupportArgPrivate privateArg;
    privateArg.SetDefault();
    privateArg.mode = nn::hid::system::ControllerSupportMode_StrapGuideForPalma;
    privateArg.caller = nn::hid::system::ControllerSupportCaller_Application;

    // ダミー引数
    ControllerSupportResultInfo dummyInfo; // 呼び出し元には返さない
    ControllerSupportArg dummyArg; // 呼び出し元には使わせない
    dummyArg.SetDefault();

    detail::ShowControllerSupportCore( &dummyInfo, dummyArg, privateArg );
}

}} // namespace nn::hid

