﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_Xpad.h>

namespace nn { namespace hid { namespace detail {

::nn::Result GetXpadGenericPadMap(
    ::nn::settings::BasicXpadGenericPadMap* outValue,
    int playerNumber) NN_NOEXCEPT;

::nn::Result SetXpadGenericPadMap(
    const ::nn::settings::BasicXpadGenericPadMap& value,
    int playerNumber) NN_NOEXCEPT;

::nn::Result ResetXpadGenericPadMap(int playerNumber) NN_NOEXCEPT;

::nn::Result GetXpadKeyboardMap(::nn::settings::BasicXpadKeyboardMap* outValue,
                                int playerNumber) NN_NOEXCEPT;

::nn::Result SetXpadKeyboardMap(
    const ::nn::settings::BasicXpadKeyboardMap& value,
    int playerNumber) NN_NOEXCEPT;

::nn::Result ResetXpadKeyboardMap(int playerNumber) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
