﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/hid/hid_Xpad.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_IXpadDriver.h"
#include "hid_XpadDriver.horizon.h"

namespace nn { namespace hid { namespace detail {

XpadDriver::XpadDriver() NN_NOEXCEPT
    : m_ActivationCount()
    , m_SamplingNumber(0)
{
    // 何もしない
}

XpadDriver::~XpadDriver() NN_NOEXCEPT
{
    // 何もしない
}

bool XpadDriver::IsActivated() NN_NOEXCEPT
{
    return !m_ActivationCount.IsZero();
}

::nn::Result XpadDriver::Activate() NN_NOEXCEPT
{
    // [TODO] 暫定対応（要変更、Result 値を適切なものに）
    NN_RESULT_THROW_UNLESS(!m_ActivationCount.IsMax(),
                           ResultGamePadDriverActivationUpperLimitOver());

    // アクティブ化した回数をインクリメント
    ++m_ActivationCount;

    NN_RESULT_SUCCESS;
}

::nn::Result XpadDriver::Deactivate() NN_NOEXCEPT
{
    // [TODO] 暫定対応（要変更、Result 値を適切なものに）
    NN_RESULT_THROW_UNLESS(!m_ActivationCount.IsZero(),
                           ResultGamePadDriverDeactivationLowerLimitOver());

    // アクティブ化した回数をデクリメント
    --m_ActivationCount;

    NN_RESULT_SUCCESS;
}

void XpadDriver::GetState(BasicXpadState* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES(!m_ActivationCount.IsZero());

    // 無入力状態に初期化
    *pOutValue = BasicXpadState();
    pOutValue->samplingNumber = m_SamplingNumber++;
}

}}} // namespace nn::hid::detail
