﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Windows.h>

namespace nn { namespace hid { namespace detail {

//!< 物理キーボードの接続数を返します。
int GetRawInputPhysicalKeyboardCount() NN_NOEXCEPT;

//!< 物理マウスの接続数を返します。
int GetRawInputPhysicalMouseCount() NN_NOEXCEPT;

//!< ゲームパッドのハンドルを取得します。
int GetRawInputGamePadHandles(HANDLE outHandles[], int count) NN_NOEXCEPT;

//!< ゲームパッドのデバイス名を取得します。
::nn::Result GetRawInputGamePadDeviceName(
    HANDLE handle, char outName[], int count) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
