﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_VibrationFileApi.h>
#include <nn/xcd/xcd_VibrationAmFmCodec.h>

namespace nn { namespace hid { namespace detail {

//!< パーサーコンテクストの実体を表す構造体 (プラットフォームによってサイズが変化し得る)
struct VibrationFileParserContextImpl
{
    const uint8_t* dataAddress;
    int32_t position;
    int32_t sampleLength;
    nn::xcd::VibrationAmFmDecoderContext decoderContextLow;
    nn::xcd::VibrationAmFmDecoderContext decoderContextHigh;
};

Result ParseVibrationFile(
    VibrationFileInfo* pOutInfo,
    VibrationFileParserContextImpl* pOutContext,
    const void* address,
    size_t fileSize) NN_NOEXCEPT;

Result RetrieveVibrationValue(
    VibrationValue* pOutValue,
    int position,
    VibrationFileParserContextImpl* pContext) NN_NOEXCEPT;

}}} // namespace nn::hid::detail


namespace nn { namespace hid {

//!< 公開ヘッダ側の構造体 (nn::hid::VibrationFileParser) と実体とのサイズ差分を埋めるための構造体
struct VibrationFileParserContextImpl
{
    //!< パーサーコンテクストの実体
    ::nn::hid::detail::VibrationFileParserContextImpl impl;

    //!< サイズ差分を埋めるためのパディング
    uint8_t _padding[sizeof(VibrationFileParserContext) - sizeof(::nn::hid::detail::VibrationFileParserContextImpl)];
};

}} // namespace nn::hid
