﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Macro.h>

namespace nn { namespace hid { namespace detail {

class SystemButtonManager;

//!< システムボタンの入力通知を行うクラスです。
class SystemButtonNotifier final
{
private:
    //!< システムボタンが押下されているか否か
    ::std::atomic<bool>* m_pIsSystemButtonDown;

    //!< システムボタンの入力通知が必要か否か
    ::std::atomic<bool>* m_pNeedsToSignal;

    //!< Notifier が監視するシステムボタンがアクティブか否か
    bool m_IsNotifierSystemButtonActive;

    //!< Notifier が監視するシステムボタンが押下中か否か
    bool m_IsNotifierSystemButtonDown;

public:
    friend class CaptureButtonManager;
    friend class HomeButtonManager;
    friend class SleepButtonManager;

    SystemButtonNotifier() NN_NOEXCEPT;

    explicit SystemButtonNotifier(const SystemButtonNotifier& other
                                  ) NN_NOEXCEPT;

    SystemButtonNotifier(SystemButtonNotifier&& other) NN_NOEXCEPT;

    SystemButtonNotifier& operator=(const SystemButtonNotifier& other
                                   ) NN_NOEXCEPT;

    SystemButtonNotifier& operator=(SystemButtonNotifier&& other) NN_NOEXCEPT;

    //!< Notifier が監視するシステムボタンの状態を設定します。
    void SetSystemButtonState(bool isDown) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
