﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/os/os_SharedMemory.h>

#include "hid_SharedMemoryFormat.h"

namespace nn { namespace hid { namespace detail {

//!< 共有メモリを保持するためのクラスです。
class SharedMemoryHolder final
{
    NN_DISALLOW_COPY(SharedMemoryHolder);

private:
    SharedMemoryHolder& operator=(SharedMemoryHolder&&) NN_NOEXCEPT;

private:
    //!< 所有権を持つか否か
    bool m_IsOwner;

    //!< 新規に構築されたか否かを表す値
    bool m_IsCreated;

    //!< マップ状態にあるか否かを表す値
    bool m_IsMapped;

    //!< 共通メモリオブジェクト
    ::nn::os::SharedMemoryType m_SharedMemory;

    //!< 共通メモリのアドレス
    SharedMemoryFormat* m_Address;

public:
    SharedMemoryHolder() NN_NOEXCEPT;

    SharedMemoryHolder(SharedMemoryHolder&& other) NN_NOEXCEPT;

    //!< マップ状態にあるか否かを表す値を返します。
    bool IsMapped() const NN_NOEXCEPT;

    //!< 共有メモリを初期化します。
    ::nn::Result Initialize() NN_NOEXCEPT;

    //!< 共有メモリをアタッチします。
    void Attach(::nn::os::NativeHandle handle) NN_NOEXCEPT;

    //!< 共有メモリを破棄します。
    void Finalize() NN_NOEXCEPT;

    //!< 共有メモリのハンドルを返します。
    ::nn::os::NativeHandle GetSharedMemoryHandle() const NN_NOEXCEPT;

    //!< 共有メモリのアドレスを返します。
    SharedMemoryFormat* GetAddress() const NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
