﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>

#include "hid_Point.h"

namespace nn { namespace hid { namespace detail {

//!< 長方形を表す構造体です。
struct Rectangle final
{
    int x;
    int y;
    int width;
    int height;

    //!< 指定された座標を含むか否かを表す値を返します。
    bool Contains(const Point& point) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(0 <= this->width);
        NN_SDK_REQUIRES(0 <= this->height);

        return this->x <= point.x && point.x < (this->x + this->width)
            && this->y <= point.y && point.y < (this->y + this->height);
    }

    //!< 指定された座標をクランプします。
    Point Clamp(const Point& point) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(0 <= this->width);
        NN_SDK_REQUIRES(0 <= this->height);

        Point value = {
            Rectangle::ClampImpl(point.x, this->x, this->width),
            Rectangle::ClampImpl(point.y, this->y, this->height)
        };

        return value;
    }

private:
    static int ClampImpl(int value, int head, int width) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(0 <= width);

        if (value < head || width == 0)
        {
            return head;
        }
        else
        {
            const int tail = head + width - 1;

            if (tail < value)
            {
                return tail;
            }
        }

        return value;
    }
};

}}} // namespace nn::hid::detail
