﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/xcd/xcd_Device.h>

#include "hid_ActivationCount.h"
#include "hid_AppletResourceManager.h"
#include "hid_InterruptSceneNotifier.h"
#include "hid_OvlnSenderManager.h"

namespace nn { namespace hid { namespace detail {

//!< Npad デバイス割り当ての解決を担うマネージャを扱うクラスです。
class RailManager final
{
    NN_DISALLOW_COPY(RailManager) NN_NOEXCEPT;
    NN_DISALLOW_MOVE(RailManager) NN_NOEXCEPT;

private:
    //!< オーバーレイ通知を送信するための型
    OvlnSenderManager* m_pSender;

    //!< 割り込みシーンの表示を通知クラス
    InterruptSceneNotifier* m_pInterruptSceneNotifier;

public:
    RailManager() NN_NOEXCEPT;

    ~RailManager() NN_NOEXCEPT;

    //!< オーバーレイ通知用のマネージャーを設定します。
    void SetOvlnSenderManager(OvlnSenderManager* pSender) NN_NOEXCEPT;

    //!< 割り込みシーンの通知クラスを設定します。
    void SetInterruptSceneNotifier(InterruptSceneNotifier* pNotifier) NN_NOEXCEPT;

    //!< レール接続部に変化があった際に通知を受けるイベントを設定します。
    void BindRailUpdateEvent(::nn::os::SystemEventType* pSystemEvent) NN_NOEXCEPT;

    //!< レール接続部に変化があった際に通知を受けるイベントを解除します。
    void UnbindRailUpdateEvent(::nn::os::SystemEventType* pSystemEvent) NN_NOEXCEPT;

    //!< レール接続部に変化があった際の処理を行います
    void HandleRailUpdateEvent() NN_NOEXCEPT;

private:
    //!< コントローラーが本体にジョイントされたことを通知する
    void NotifyAttachment(system::NpadDeviceTypeSet device,
                          const bool isColorValid,
                          const NpadControllerColor& color,
                          bool isAttached) NN_NOEXCEPT;

};

}}} // namespace nn::hid::detail
